/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NonReducibleCompositeItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public final class WeakAndItem
extends NonReducibleCompositeItem {
    private int N;
    @NonNull
    private String index;
    private int scoreThreshold = 0;
    public static final int defaultN = 100;

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WEAK_AND;
    }

    @Override
    public String getName() {
        return "WAND";
    }

    public WeakAndItem(String index, int N) {
        this.N = N;
        this.index = index == null ? "" : index;
    }

    public WeakAndItem(int N) {
        this("", N);
    }

    @Override
    public void setIndexName(String index) {
        String toSet = index == null ? "" : index;
        super.setIndexName(toSet);
        this.index = toSet;
    }

    @NonNull
    public String getIndexName() {
        return this.index;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.N);
        buffer.append(")");
        buffer.append(" ");
    }

    public WeakAndItem() {
        this(100);
    }

    public int getN() {
        return this.N;
    }

    public void setN(int N) {
        this.N = N;
    }

    public int getScoreThreshold() {
        return this.scoreThreshold;
    }

    public void setScoreThreshold(int scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.N, (ByteBuffer)buffer);
        WeakAndItem.putString(this.index, buffer);
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("N", this.N);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.N;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        WeakAndItem other = (WeakAndItem)object;
        return this.N == other.N;
    }
}

