/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.ChannelTimeoutException;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.fs4.mplex.FS4Channel;
import com.yahoo.fs4.mplex.InvalidChannelException;
import com.yahoo.prelude.fastsearch.CacheControl;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import com.yahoo.prelude.fastsearch.PacketWrapper;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.ResponseMonitor;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FS4SearchInvoker
extends SearchInvoker
implements ResponseMonitor<FS4Channel> {
    private final VespaBackEndSearcher searcher;
    private FS4Channel channel;
    private ErrorMessage pendingSearchError = null;
    private Query query = null;
    private QueryPacket queryPacket = null;

    public FS4SearchInvoker(VespaBackEndSearcher searcher, Query query, FS4Channel channel, Optional<Node> node) {
        super(node);
        this.searcher = searcher;
        this.channel = channel;
        channel.setQuery(query);
        channel.setResponseMonitor(this);
    }

    @Override
    protected void sendSearchRequest(Query query, QueryPacket queryPacket) throws IOException {
        if (this.isLoggingFine()) {
            this.getLogger().finest("sending query packet");
        }
        if (queryPacket == null) {
            queryPacket = this.searcher.createQueryPacket(this.searcher.getServerId(), query);
        }
        this.query = query;
        this.queryPacket = queryPacket;
        try {
            boolean couldSend = this.channel.sendPacket(queryPacket);
            if (!couldSend) {
                this.pendingSearchError = ErrorMessage.createBackendCommunicationError("Could not reach '" + this.getName() + "'");
            }
        }
        catch (InvalidChannelException e) {
            this.pendingSearchError = ErrorMessage.createBackendCommunicationError("Invalid channel " + this.getName());
        }
        catch (IllegalStateException e) {
            this.pendingSearchError = ErrorMessage.createBackendCommunicationError("Illegal state in FS4: " + e.getMessage());
        }
    }

    @Override
    protected Result getSearchResult(CacheKey cacheKey, Execution execution) throws IOException {
        BasicPacket[] basicPackets;
        if (this.pendingSearchError != null) {
            return this.errorResult(this.pendingSearchError);
        }
        try {
            basicPackets = this.channel.receivePackets(this.query.getTimeLeft(), 1);
        }
        catch (ChannelTimeoutException e) {
            return this.errorResult(ErrorMessage.createTimeout("Timeout while waiting for " + this.getName()));
        }
        catch (InvalidChannelException e) {
            return this.errorResult(ErrorMessage.createBackendCommunicationError("Invalid channel for " + this.getName()));
        }
        if (basicPackets.length == 0) {
            return this.errorResult(ErrorMessage.createBackendCommunicationError(this.getName() + " got no packets back"));
        }
        if (this.isLoggingFine()) {
            this.getLogger().finest("got packets " + basicPackets.length + " packets");
        }
        basicPackets[0].ensureInstanceOf(QueryResultPacket.class, this.getName());
        QueryResultPacket resultPacket = (QueryResultPacket)basicPackets[0];
        if (this.isLoggingFine()) {
            this.getLogger().finest("got query packet. docsumClass=" + this.query.getPresentation().getSummary());
        }
        if (this.query.getPresentation().getSummary() == null) {
            this.query.getPresentation().setSummary(this.searcher.getDefaultDocsumClass());
        }
        Result result = new Result(this.query);
        this.searcher.addMetaInfo(this.query, this.queryPacket.getQueryPacketData(), resultPacket, result);
        this.searcher.addUnfilledHits(result, resultPacket.getDocuments(), false, this.queryPacket.getQueryPacketData(), cacheKey, this.distributionKey());
        CacheControl cacheControl = this.searcher.getCacheControl();
        PacketWrapper packetWrapper = cacheControl.lookup(cacheKey, this.query);
        if (packetWrapper != null) {
            cacheControl.updateCacheEntry(cacheKey, this.query, resultPacket);
        } else if (!resultPacket.getCoverageFeature() || resultPacket.getCoverageFull()) {
            Packet[] packets = new Packet[]{resultPacket};
            cacheControl.cache(cacheKey, this.query, new DocsumPacketKey[0], packets, this.distributionKey());
        }
        return result;
    }

    private Result errorResult(ErrorMessage errorMessage) {
        Result error = new Result(this.query, errorMessage);
        this.getErrorCoverage().ifPresent(error::setCoverage);
        return error;
    }

    @Override
    public void release() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    private String getName() {
        return this.searcher.getName();
    }

    private Logger getLogger() {
        return this.searcher.getLogger();
    }

    private boolean isLoggingFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    @Override
    public void responseAvailable(FS4Channel from) {
        this.responseAvailable();
    }
}

