/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableMap;
import com.yahoo.fs4.mplex.Backend;
import com.yahoo.prelude.fastsearch.FS4FillInvoker;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FS4SearchInvoker;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InterleavedFillInvoker;
import com.yahoo.search.dispatch.InterleavedSearchInvoker;
import com.yahoo.search.dispatch.SearchErrorInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchCluster;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class FS4InvokerFactory {
    private final FS4ResourcePool fs4ResourcePool;
    private final VespaBackEndSearcher searcher;
    private final SearchCluster searchCluster;
    private final ImmutableMap<Integer, Node> nodesByKey;

    public FS4InvokerFactory(FS4ResourcePool fs4ResourcePool, SearchCluster searchCluster, VespaBackEndSearcher searcher) {
        this.fs4ResourcePool = fs4ResourcePool;
        this.searcher = searcher;
        this.searchCluster = searchCluster;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        searchCluster.groups().values().forEach(group -> group.nodes().forEach(node -> builder.put((Object)node.key(), node)));
        this.nodesByKey = builder.build();
    }

    public SearchInvoker getSearchInvoker(Query query, Node node) {
        Backend backend = this.fs4ResourcePool.getBackend(node.hostname(), node.fs4port());
        return new FS4SearchInvoker(this.searcher, query, backend.openChannel(), Optional.of(node));
    }

    public Optional<SearchInvoker> getSearchInvoker(Query query, int groupId, List<Node> nodes, boolean acceptIncompleteCoverage) {
        ArrayList<SearchInvoker> invokers = new ArrayList<SearchInvoker>(nodes.size());
        HashSet<Integer> failed = null;
        for (Node node : nodes) {
            Backend backend;
            boolean nodeAdded = false;
            if (node.isWorking() && (backend = this.fs4ResourcePool.getBackend(node.hostname(), node.fs4port())).probeConnection()) {
                invokers.add(new FS4SearchInvoker(this.searcher, query, backend.openChannel(), Optional.of(node)));
                nodeAdded = true;
            }
            if (nodeAdded) continue;
            if (failed == null) {
                failed = new HashSet<Integer>();
            }
            failed.add(node.key());
        }
        if (failed != null) {
            ArrayList<Node> success = new ArrayList<Node>(nodes.size() - failed.size());
            for (Node node : nodes) {
                if (failed.contains(node.key())) continue;
                success.add(node);
            }
            if (!this.searchCluster.isPartialGroupCoverageSufficient(groupId, success)) {
                if (acceptIncompleteCoverage) {
                    invokers.add(this.createCoverageErrorInvoker(nodes, failed));
                } else {
                    return Optional.empty();
                }
            }
        }
        if (invokers.size() == 1) {
            return Optional.of(invokers.get(0));
        }
        return Optional.of(new InterleavedSearchInvoker(invokers, this.searcher, this.searchCluster));
    }

    private SearchInvoker createCoverageErrorInvoker(List<Node> nodes, Set<Integer> failed) {
        long activeDocuments = 0L;
        StringBuilder down = new StringBuilder("Connection failure on nodes with distribution-keys: ");
        Integer key = null;
        for (Node node : nodes) {
            if (!failed.contains(node.key())) continue;
            activeDocuments += node.getActiveDocuments();
            if (key == null) {
                key = node.key();
            } else {
                down.append(", ");
            }
            down.append(node.key());
        }
        Coverage coverage = new Coverage(0L, activeDocuments, 0);
        coverage.setNodesTried(1);
        return new SearchErrorInvoker(ErrorMessage.createBackendCommunicationError(down.toString()), coverage);
    }

    public FillInvoker getFillInvoker(Query query, Node node) {
        return new FS4FillInvoker(this.searcher, query, this.fs4ResourcePool, node.hostname(), node.fs4port());
    }

    public Optional<FillInvoker> getFillInvoker(Result result) {
        Collection<Integer> requiredNodes = FS4InvokerFactory.requiredFillNodes(result);
        Query query = result.getQuery();
        HashMap<Integer, FillInvoker> invokers = new HashMap<Integer, FillInvoker>();
        for (Integer distKey : requiredNodes) {
            Node node = (Node)this.nodesByKey.get((Object)distKey);
            if (node == null) {
                return Optional.empty();
            }
            invokers.put(distKey, this.getFillInvoker(query, node));
        }
        if (invokers.size() == 1) {
            return Optional.of(invokers.values().iterator().next());
        }
        return Optional.of(new InterleavedFillInvoker(invokers));
    }

    private static Collection<Integer> requiredFillNodes(Result result) {
        HashSet<Integer> requiredNodes = new HashSet<Integer>();
        Iterator<Hit> i = result.hits().unorderedDeepIterator();
        while (i.hasNext()) {
            Hit h = i.next();
            if (!(h instanceof FastHit)) continue;
            FastHit hit = (FastHit)h;
            requiredNodes.add(hit.getDistributionKey());
        }
        return requiredNodes;
    }
}

