/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.google.common.collect.ImmutableMap;
import com.yahoo.container.search.LegacyEmulationConfig;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.RankProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class DocumentDatabase {
    public static final String MATCH_PROPERTY = "match";
    public static final String SEARCH_DOC_TYPE_KEY = "documentdb.searchdoctype";
    private final String name;
    private final DocsumDefinitionSet docsumDefSet;
    private final ImmutableMap<String, RankProfile> rankProfiles;

    public DocumentDatabase(DocumentdbInfoConfig.Documentdb documentDb, LegacyEmulationConfig emulConfig) {
        this(documentDb.name(), new DocsumDefinitionSet(documentDb, emulConfig), DocumentDatabase.toRankProfiles(documentDb.rankprofile()));
    }

    public DocumentDatabase(String name, DocsumDefinitionSet docsumDefinitionSet, Collection<RankProfile> rankProfiles) {
        this.name = name;
        this.docsumDefSet = docsumDefinitionSet;
        this.rankProfiles = ImmutableMap.copyOf(rankProfiles.stream().collect(Collectors.toMap(RankProfile::getName, p -> p)));
    }

    public String getName() {
        return this.name;
    }

    public DocsumDefinitionSet getDocsumDefinitionSet() {
        return this.docsumDefSet;
    }

    public Map<String, RankProfile> rankProfiles() {
        return this.rankProfiles;
    }

    private static ImmutableMap<String, RankProfile> toMap(Collection<RankProfile> rankProfiles) {
        return ImmutableMap.copyOf(rankProfiles.stream().collect(Collectors.toMap(RankProfile::getName, p -> p)));
    }

    private static Collection<RankProfile> toRankProfiles(Collection<DocumentdbInfoConfig.Documentdb.Rankprofile> rankProfileConfigList) {
        ArrayList<RankProfile> rankProfiles = new ArrayList<RankProfile>();
        for (DocumentdbInfoConfig.Documentdb.Rankprofile c : rankProfileConfigList) {
            rankProfiles.add(new RankProfile(c.name(), c.hasSummaryFeatures(), c.hasRankFeatures()));
        }
        return rankProfiles;
    }
}

