/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.collections.Tuple2;
import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.concurrent.Receiver;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.container.search.LegacyEmulationConfig;
import com.yahoo.fs4.mplex.Backend;
import com.yahoo.net.HostName;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.cluster.ClusterMonitor;
import com.yahoo.prelude.cluster.QrMonitorConfig;
import com.yahoo.prelude.fastsearch.CacheControl;
import com.yahoo.prelude.fastsearch.CacheParams;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.search.query.ParameterParser;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.streamingvisitors.VdsStreamingSearcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@After(value={"*"})
public class ClusterSearcher
extends Searcher {
    private static final Logger log = Logger.getLogger(ClusterSearcher.class.getName());
    private final ClusterMonitor monitor;
    private final Value cacheHitRatio;
    private final String clusterModelName;
    private final Set<String> documentTypes;
    private final Map<String, Set<String>> rankProfiles = new HashMap<String, Set<String>>();
    private final FS4ResourcePool fs4ResourcePool;
    private final long maxQueryTimeout;
    private static final long DEFAULT_MAX_QUERY_TIMEOUT = 600000L;
    private final long maxQueryCacheTimeout;
    private static final long DEFAULT_MAX_QUERY_CACHE_TIMEOUT = 10000L;
    private VespaBackEndSearcher server = null;

    public ClusterSearcher(ComponentId id, QrSearchersConfig qrsConfig, ClusterConfig clusterConfig, DocumentdbInfoConfig documentDbConfig, LegacyEmulationConfig emulationConfig, QrMonitorConfig monitorConfig, DispatchConfig dispatchConfig, ClusterInfoConfig clusterInfoConfig, Statistics manager, FS4ResourcePool fs4ResourcePool, VipStatus vipStatus) {
        super(id);
        this.fs4ResourcePool = fs4ResourcePool;
        Dispatcher dispatcher = new Dispatcher(id.stringValue(), dispatchConfig, fs4ResourcePool, clusterInfoConfig.nodeCount(), vipStatus);
        this.monitor = dispatcher.searchCluster().directDispatchTarget().isPresent() ? new ClusterMonitor(this, monitorConfig, Optional.empty()) : new ClusterMonitor(this, monitorConfig, Optional.of(vipStatus));
        int searchClusterIndex = clusterConfig.clusterId();
        this.clusterModelName = clusterConfig.clusterName();
        QrSearchersConfig.Searchcluster searchClusterConfig = ClusterSearcher.getSearchClusterConfigFromClusterName(qrsConfig, this.clusterModelName);
        this.documentTypes = new LinkedHashSet<String>();
        String eventName = this.clusterModelName + ".cache_hit_ratio";
        this.cacheHitRatio = new Value(eventName, manager, new Value.Parameters().setNameExtension(Boolean.valueOf(false)).setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)));
        this.maxQueryTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryTimeout(), 600000L);
        this.maxQueryCacheTimeout = ParameterParser.asMilliSeconds(clusterConfig.maxQueryCacheTimeout(), 10000L);
        CacheParams cacheParams = new CacheParams(ClusterSearcher.createCache(clusterConfig, this.clusterModelName));
        SummaryParameters docSumParams = new SummaryParameters(qrsConfig.com().yahoo().prelude().fastsearch().FastSearcher().docsum().defaultclass());
        for (DocumentdbInfoConfig.Documentdb docDb : documentDbConfig.documentdb()) {
            String docTypeName = docDb.name();
            this.documentTypes.add(docTypeName);
            for (DocumentdbInfoConfig.Documentdb.Rankprofile profile : docDb.rankprofile()) {
                this.addValidRankProfile(profile.name(), docTypeName);
            }
        }
        if (searchClusterConfig.indexingmode() == QrSearchersConfig.Searchcluster.Indexingmode.STREAMING) {
            VdsStreamingSearcher searcher = ClusterSearcher.vdsCluster(fs4ResourcePool.getServerId(), searchClusterIndex, searchClusterConfig, cacheParams, emulationConfig, docSumParams, documentDbConfig);
            this.addBackendSearcher(searcher);
        } else {
            for (int dispatcherIndex = 0; dispatcherIndex < searchClusterConfig.dispatcher().size(); ++dispatcherIndex) {
                try {
                    if (this.isRemote(searchClusterConfig.dispatcher(dispatcherIndex).host())) continue;
                    Backend dispatchBackend = this.createBackend(searchClusterConfig.dispatcher(dispatcherIndex));
                    FastSearcher searcher = ClusterSearcher.searchDispatch(searchClusterIndex, fs4ResourcePool, cacheParams, emulationConfig, docSumParams, documentDbConfig, dispatchBackend, dispatcher, dispatcherIndex);
                    this.addBackendSearcher(searcher);
                    continue;
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.server == null) {
            log.log(Level.SEVERE, "ClusterSearcher should have a top level dispatch.");
        }
        this.monitor.freeze();
        this.monitor.startPingThread();
    }

    private static QrSearchersConfig.Searchcluster getSearchClusterConfigFromClusterName(QrSearchersConfig config, String name) {
        for (QrSearchersConfig.Searchcluster searchCluster : config.searchcluster()) {
            if (!searchCluster.name().equals(name)) continue;
            return searchCluster;
        }
        return null;
    }

    boolean isRemote(String host) throws UnknownHostException {
        return InetAddress.getByName(host).isLoopbackAddress() ? false : !host.equals(HostName.getLocalhost());
    }

    private static ClusterParams makeClusterParams(int searchclusterIndex, LegacyEmulationConfig emulConfig, int dispatchIndex) {
        return new ClusterParams("sc" + searchclusterIndex + ".num" + dispatchIndex, emulConfig);
    }

    private static FastSearcher searchDispatch(int searchclusterIndex, FS4ResourcePool fs4ResourcePool, CacheParams cacheParams, LegacyEmulationConfig emulConfig, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig, Backend backend, Dispatcher dispatcher, int dispatcherIndex) {
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex, emulConfig, dispatcherIndex);
        return new FastSearcher(backend, fs4ResourcePool, dispatcher, docSumParams, clusterParams, cacheParams, documentdbInfoConfig);
    }

    private static VdsStreamingSearcher vdsCluster(String serverId, int searchclusterIndex, QrSearchersConfig.Searchcluster searchClusterConfig, CacheParams cacheParams, LegacyEmulationConfig emulConfig, SummaryParameters docSumParams, DocumentdbInfoConfig documentdbInfoConfig) {
        if (searchClusterConfig.searchdef().size() != 1) {
            throw new IllegalArgumentException("Search clusters in streaming search shall only contain a single searchdefinition : " + searchClusterConfig.searchdef());
        }
        ClusterParams clusterParams = ClusterSearcher.makeClusterParams(searchclusterIndex, emulConfig, 0);
        VdsStreamingSearcher searcher = (VdsStreamingSearcher)VespaBackEndSearcher.getSearcher("com.yahoo.vespa.streamingvisitors.VdsStreamingSearcher");
        searcher.setSearchClusterConfigId(searchClusterConfig.rankprofiles().configid());
        searcher.setDocumentType(searchClusterConfig.searchdef(0));
        searcher.setStorageClusterRouteSpec(searchClusterConfig.storagecluster().routespec());
        searcher.init(serverId, docSumParams, clusterParams, cacheParams, documentdbInfoConfig);
        return searcher;
    }

    ClusterSearcher(Set<String> documentTypes) {
        this.documentTypes = documentTypes;
        this.monitor = new ClusterMonitor(this, new QrMonitorConfig(new QrMonitorConfig.Builder()), Optional.of(new VipStatus()));
        this.cacheHitRatio = new Value("com.yahoo.prelude.cluster.ClusterSearcher.ClusterSearcher().dummy", Statistics.nullImplementation, new Value.Parameters());
        this.clusterModelName = "testScenario";
        this.fs4ResourcePool = null;
        this.maxQueryTimeout = 600000L;
        this.maxQueryCacheTimeout = 10000L;
    }

    private Backend createBackend(QrSearchersConfig.Searchcluster.Dispatcher disp) {
        return this.fs4ResourcePool.getBackend(disp.host(), disp.port());
    }

    private static CacheControl createCache(ClusterConfig config, String clusterModelName) {
        log.log(Level.INFO, "Enabling cache for search cluster " + clusterModelName + " (size=" + config.cacheSize() + ", timeout=" + config.cacheTimeout() + ")");
        return new CacheControl(config.cacheSize(), config.cacheTimeout());
    }

    ClusterMonitor getMonitor() {
        return this.monitor;
    }

    void addBackendSearcher(VespaBackEndSearcher searcher) {
        this.monitor.add(searcher);
        this.server = searcher;
    }

    void addValidRankProfile(String profileName, String docTypeName) {
        if (!this.rankProfiles.containsKey(profileName)) {
            this.rankProfiles.put(profileName, new HashSet());
        }
        this.rankProfiles.get(profileName).add(docTypeName);
    }

    void setValidRankProfile(String profileName, Set<String> documentTypes) {
        this.rankProfiles.put(profileName, documentTypes);
    }

    private Result checkValidRankProfiles(Query query, Set<String> docTypes) {
        String rankProfile = query.getRanking().getProfile();
        Set<String> invalidInDocTypes = null;
        Set<String> rankDocTypes = this.rankProfiles.get(rankProfile);
        if (rankDocTypes == null) {
            invalidInDocTypes = docTypes;
        } else if (docTypes.size() == 1) {
            if (!rankDocTypes.contains(docTypes.iterator().next())) {
                invalidInDocTypes = docTypes;
            }
        } else {
            Set<String> restrict = query.getModel().getRestrict();
            Set<String> sources = query.getModel().getSources();
            boolean validate = restrict != null && !restrict.isEmpty();
            boolean bl = validate = validate || sources != null && !sources.isEmpty();
            if (validate && !rankDocTypes.containsAll(docTypes)) {
                invalidInDocTypes = new HashSet<String>(docTypes);
                invalidInDocTypes.removeAll(rankDocTypes);
            }
        }
        if (invalidInDocTypes != null && !invalidInDocTypes.isEmpty()) {
            String plural = invalidInDocTypes.size() > 1 ? "s" : "";
            return new Result(query, ErrorMessage.createInvalidQueryParameter("Requested rank profile '" + rankProfile + "' is undefined for document type" + plural + " '" + StringUtils.join(invalidInDocTypes.iterator(), (String)", ") + "'"));
        }
        return null;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        Query query = result.getQuery();
        VespaBackEndSearcher searcher = this.server;
        if (searcher != null) {
            if (query.getTimeLeft() > 0L) {
                this.doFill(searcher, result, summaryClass, execution);
            } else if (result.hits().getErrorHit() == null) {
                result.hits().addError(ErrorMessage.createTimeout("No time left to get summaries"));
            }
        } else if (result.hits().getErrorHit() == null) {
            result.hits().addError(ErrorMessage.createNoBackendsInService("Could not fill result"));
        }
    }

    private void doFill(Searcher searcher, Result result, String summaryClass, Execution execution) {
        searcher.fill(result, summaryClass, execution);
        this.updateCacheHitRatio(result, result.getQuery());
    }

    private void updateCacheHitRatio(Result result, Query query) {
        if (result.hits().getError() == null && result.hits().getConcreteSize() > 0) {
            if (result.isCached()) {
                this.cacheHit();
            } else if (!query.getNoCache()) {
                this.cacheMiss();
            }
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        this.validateQueryTimeout(query);
        this.validateQueryCache(query);
        VespaBackEndSearcher searcher = this.server;
        if (searcher == null) {
            return new Result(query, ErrorMessage.createNoBackendsInService("Could not search"));
        }
        if (query.getTimeLeft() <= 0L) {
            return new Result(query, ErrorMessage.createTimeout("No time left for searching"));
        }
        return this.doSearch(searcher, query, execution);
    }

    private void validateQueryTimeout(Query query) {
        if (query.getTimeout() <= this.maxQueryTimeout) {
            return;
        }
        if (query.isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query timeout (" + this.maxQueryTimeout + " ms). Setting timeout to " + this.maxQueryTimeout + " ms.", 2);
        }
        query.setTimeout(this.maxQueryTimeout);
    }

    private void validateQueryCache(Query query) {
        if (!query.getRanking().getQueryCache()) {
            return;
        }
        if (query.getTimeout() <= this.maxQueryCacheTimeout) {
            return;
        }
        if (query.isTraceable(2)) {
            query.trace("Query timeout (" + query.getTimeout() + " ms) > max query cache timeout (" + this.maxQueryCacheTimeout + " ms). Disabling query cache.", 2);
        }
        query.getRanking().setQueryCache(false);
    }

    private Result doSearch(Searcher searcher, Query query, Execution execution) {
        Result result;
        if (this.documentTypes.size() > 1) {
            result = this.searchMultipleDocumentTypes(searcher, query, execution);
        } else {
            String docType = this.documentTypes.iterator().next();
            Result invalidRankProfile = this.checkValidRankProfiles(query, this.documentTypes);
            if (invalidRankProfile != null) {
                return invalidRankProfile;
            }
            query.getModel().setRestrict(docType);
            result = searcher.search(query, execution);
        }
        this.updateCacheHitRatio(result, query);
        return result;
    }

    private Result searchMultipleDocumentTypes(Searcher searcher, Query query, Execution execution) {
        Set<String> docTypes = this.resolveDocumentTypes(query, execution.context().getIndexFacts());
        Result invalidRankProfile = this.checkValidRankProfiles(query, docTypes);
        if (invalidRankProfile != null) {
            return invalidRankProfile;
        }
        List<Query> queries = this.createQueries(query, docTypes);
        if (queries.size() == 1) {
            return searcher.search(queries.get(0), execution);
        }
        Result mergedResult = new Result(query.clone());
        for (Query q : queries) {
            Result result = searcher.search(q, execution);
            mergedResult.mergeWith(result);
            mergedResult.hits().addAll(result.hits().asUnorderedHits());
        }
        if (query.getOffset() > 0 || query.getHits() < mergedResult.hits().size()) {
            if (mergedResult.getHitOrderer() != null) {
                searcher.fill(mergedResult, "attributeprefetch", execution);
            }
            mergedResult.hits().trim(query.getOffset(), query.getHits());
        }
        return mergedResult;
    }

    Set<String> resolveDocumentTypes(Query query, IndexFacts indexFacts) {
        Set<String> restrict = query.getModel().getRestrict();
        if (restrict == null || restrict.isEmpty()) {
            Set<String> sources = query.getModel().getSources();
            return sources == null || sources.isEmpty() ? this.documentTypes : new HashSet<String>(indexFacts.newSession(sources, Collections.emptyList(), this.documentTypes).documentTypes());
        }
        return this.filterValidDocumentTypes(restrict);
    }

    private Set<String> filterValidDocumentTypes(Collection<String> restrict) {
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        for (String docType : restrict) {
            if (docType == null || !this.documentTypes.contains(docType)) continue;
            retval.add(docType);
        }
        return retval;
    }

    private List<Query> createQueries(Query query, Set<String> docTypes) {
        query.getModel().getQueryTree();
        ArrayList<Query> retval = new ArrayList<Query>(docTypes.size());
        if (docTypes.size() == 1) {
            query.getModel().setRestrict(docTypes.iterator().next());
            retval.add(query);
        } else if (!docTypes.isEmpty()) {
            for (String docType : docTypes) {
                Query q = query.clone();
                q.setOffset(0);
                q.setHits(query.getOffset() + query.getHits());
                q.getModel().setRestrict(docType);
                retval.add(q);
            }
        }
        return retval;
    }

    private void cacheHit() {
        this.cacheHitRatio.put(1.0);
    }

    private void cacheMiss() {
        this.cacheHitRatio.put(0.0);
    }

    void working(VespaBackEndSearcher node) {
        this.server = node;
    }

    void failed(VespaBackEndSearcher node) {
        this.server = null;
    }

    void ping(VespaBackEndSearcher node) throws InterruptedException {
        log.fine("Sending ping to: " + (Object)((Object)node));
        Pinger pinger = new Pinger(node);
        this.getExecutor().execute(pinger);
        Pong pong = pinger.getPong();
        if (pong == null) {
            this.monitor.failed(node, ErrorMessage.createNoAnswerWhenPingingNode("Ping thread timed out."));
        } else if (pong.badResponse()) {
            this.monitor.failed(node, pong.getError(0));
        } else {
            this.monitor.responded(node, this.backendCanServeDocuments(pong));
        }
    }

    private boolean backendCanServeDocuments(Pong pong) {
        if (!pong.activeNodes().isPresent()) {
            return true;
        }
        return pong.activeNodes().get() > 0;
    }

    public void deconstruct() {
        this.monitor.shutdown();
    }

    ExecutorService getExecutor() {
        return this.fs4ResourcePool.getExecutor();
    }

    ScheduledExecutorService getScheduledExecutor() {
        return this.fs4ResourcePool.getScheduledExecutor();
    }

    private class Pinger
    implements Runnable {
        private final Searcher searcher;
        private final Ping pingChallenge;
        private final Receiver<Pong> pong;

        Pinger(Searcher searcher) {
            this.pingChallenge = new Ping(ClusterSearcher.this.monitor.getConfiguration().getRequestTimeout());
            this.pong = new Receiver();
            this.searcher = searcher;
        }

        @Override
        public void run() {
            this.pong.put((Object)this.createExecution().ping(this.pingChallenge));
        }

        private Execution createExecution() {
            return new Execution((Chain<? extends Searcher>)new Chain((ChainedComponent[])new Searcher[]{this.searcher}), new Execution.Context(null, null, null, null, null));
        }

        public Pong getPong() throws InterruptedException {
            Tuple2 reply = this.pong.get(this.pingChallenge.getTimeout() + 150L);
            return reply.first != Receiver.MessageState.VALID ? null : (Pong)reply.second;
        }
    }
}

