/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.streamingvisitors;

import com.yahoo.document.DocumentId;
import com.yahoo.document.idstring.IdString;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.select.parser.TokenMgrError;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.log.LogLevel;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.vdslib.DocumentSummary;
import com.yahoo.vdslib.SearchResult;
import com.yahoo.vespa.streamingvisitors.VdsVisitor;
import com.yahoo.vespa.streamingvisitors.Visitor;
import com.yahoo.vespa.streamingvisitors.VisitorFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VdsStreamingSearcher
extends VespaBackEndSearcher {
    private static final CompoundName streamingUserid = new CompoundName("streaming.userid");
    private static final CompoundName streamingGroupname = new CompoundName("streaming.groupname");
    private static final CompoundName streamingSelection = new CompoundName("streaming.selection");
    public static final String STREAMING_STATISTICS = "streaming.statistics";
    private VisitorFactory visitorFactory;
    private static final Logger log = Logger.getLogger(VdsStreamingSearcher.class.getName());
    private Route route;
    private String searchClusterConfigId = null;
    private String storageClusterRouteSpec = null;

    String getSearchClusterConfigId() {
        return this.searchClusterConfigId;
    }

    String getStorageClusterRouteSpec() {
        return this.storageClusterRouteSpec;
    }

    public final void setSearchClusterConfigId(String clusterName) {
        this.searchClusterConfigId = clusterName;
    }

    public final void setStorageClusterRouteSpec(String storageClusterRouteSpec) {
        this.storageClusterRouteSpec = storageClusterRouteSpec;
    }

    public VdsStreamingSearcher() {
        this.visitorFactory = new VdsVisitorFactory();
    }

    public VdsStreamingSearcher(VisitorFactory visitorFactory) {
        this.visitorFactory = visitorFactory;
    }

    @Override
    protected void doPartialFill(Result result, String summaryClass) {
    }

    @Override
    public Result doSearch2(Query query, QueryPacket queryPacket, CacheKey cacheKey, Execution execution) {
        int skippedHits;
        VdsStreamingSearcher.lazyTrace(query, 7, "Routing to storage cluster ", this.getStorageClusterRouteSpec());
        if (this.route == null) {
            this.route = Route.parse((String)this.getStorageClusterRouteSpec());
        }
        VdsStreamingSearcher.lazyTrace(query, 8, "Route is ", this.route);
        VdsStreamingSearcher.lazyTrace(query, 7, "doSearch2(): query docsum class=", query.getPresentation().getSummary(), ", default docsum class=", this.getDefaultDocsumClass());
        if (query.getPresentation().getSummary() == null) {
            VdsStreamingSearcher.lazyTrace(query, 6, "doSearch2(): No summary class specified in query, using default: ", this.getDefaultDocsumClass());
            query.getPresentation().setSummary(this.getDefaultDocsumClass());
        } else {
            VdsStreamingSearcher.lazyTrace(query, 6, "doSearch2(): Summary class has been specified in query: ", query.getPresentation().getSummary());
        }
        VdsStreamingSearcher.lazyTrace(query, 8, "doSearch2(): rank properties=", query.getRanking());
        VdsStreamingSearcher.lazyTrace(query, 8, "doSearch2(): sort specification=", query.getRanking().getSorting() == null ? null : query.getRanking().getSorting().fieldOrders());
        int documentSelectionQueryParameterCount = 0;
        if (query.properties().getString(streamingUserid) != null) {
            ++documentSelectionQueryParameterCount;
        }
        if (query.properties().getString(streamingGroupname) != null) {
            ++documentSelectionQueryParameterCount;
        }
        if (query.properties().getString(streamingSelection) != null) {
            ++documentSelectionQueryParameterCount;
        }
        if (documentSelectionQueryParameterCount != 1) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Streaming search needs one and only one of these query parameters to be set: streaming.userid, streaming.groupname, streaming.selection"));
        }
        query.trace("Routing to search cluster " + this.getSearchClusterConfigId(), 4);
        Visitor visitor = this.visitorFactory.createVisitor(query, this.getSearchClusterConfigId(), this.route);
        try {
            visitor.doSearch();
        }
        catch (ParseException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Failed to parse document selection string: " + e.getMessage() + "'."));
        }
        catch (TokenMgrError e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Failed to tokenize document selection string: " + e.getMessage() + "'."));
        }
        catch (TimeoutException e) {
            return new Result(query, ErrorMessage.createTimeout(e.getMessage()));
        }
        catch (IllegalArgumentException | InterruptedException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError(e.getMessage()));
        }
        VdsStreamingSearcher.lazyTrace(query, 8, "offset=", query.getOffset(), ", hits=", query.getHits());
        Result result = new Result(query);
        List<SearchResult.Hit> hits = visitor.getHits();
        Map<String, DocumentSummary.Summary> summaryMap = visitor.getSummaryMap();
        VdsStreamingSearcher.lazyTrace(query, 7, "total hit count = ", visitor.getTotalHitCount(), ", returned hit count = ", hits.size(), ", summary count = ", summaryMap.size());
        result.setTotalHitCount(visitor.getTotalHitCount());
        query.trace(visitor.getStatistics().toString(), false, 2);
        query.getContext(true).setProperty(STREAMING_STATISTICS, visitor.getStatistics());
        Packet[] summaryPackets = new Packet[hits.size()];
        int index = 0;
        boolean skippedEarlierResult = false;
        for (SearchResult.Hit hit : hits) {
            if (!VdsStreamingSearcher.verifyDocId(hit.getDocId(), query, skippedEarlierResult)) {
                skippedEarlierResult = true;
                continue;
            }
            FastHit fastHit = this.buildSummaryHit(query, hit);
            result.hits().add(fastHit);
            DocumentSummary.Summary summary = summaryMap.get(hit.getDocId());
            if (summary == null) {
                return new Result(query, ErrorMessage.createBackendCommunicationError("Did not find summary for hit with document id " + hit.getDocId()));
            }
            DocsumPacket dp = new DocsumPacket(summary.getSummary());
            summaryPackets[index] = dp;
            ++index;
        }
        if (result.isFilled(query.getPresentation().getSummary())) {
            VdsStreamingSearcher.lazyTrace(query, 8, "Result is filled for summary class ", query.getPresentation().getSummary());
        } else {
            VdsStreamingSearcher.lazyTrace(query, 8, "Result is not filled for summary class ", query.getPresentation().getSummary());
        }
        List<Grouping> groupingList = visitor.getGroupings();
        VdsStreamingSearcher.lazyTrace(query, 8, "Grouping list=", groupingList);
        if (!groupingList.isEmpty()) {
            GroupingListHit groupHit = new GroupingListHit(groupingList, this.getDocsumDefinitionSet(query));
            result.hits().add(groupHit);
        }
        try {
            skippedHits = this.fillHits(result, 0, summaryPackets, query.getPresentation().getSummary());
        }
        catch (IOException e) {
            return new Result(query, ErrorMessage.createBackendCommunicationError("Error filling hits with summary fields"));
        }
        if (skippedHits == 0) {
            query.trace("All hits have been filled", 4);
        } else {
            VdsStreamingSearcher.lazyTrace(query, 8, "Skipping some hits for query: ", result.getQuery());
        }
        VdsStreamingSearcher.lazyTrace(query, 8, "Returning result ", result);
        if (skippedHits > 0) {
            this.getLogger().info("skipping " + skippedHits + " hits for query: " + result.getQuery());
            result.hits().addError(ErrorMessage.createTimeout("Missing hit summary data for " + skippedHits + " hits"));
        }
        return result;
    }

    private FastHit buildSummaryHit(Query query, SearchResult.Hit hit) {
        FastHit fastHit = new FastHit();
        fastHit.setQuery(query);
        fastHit.setSource(this.getName());
        fastHit.setId(hit.getDocId());
        fastHit.setRelevance(new Relevance(hit.getRank()));
        fastHit.setFillable();
        return fastHit;
    }

    private static void lazyTrace(Query query, int level, Object ... args) {
        if (query.isTraceable(level)) {
            StringBuilder s = new StringBuilder();
            for (Object arg : args) {
                s.append(arg);
            }
            query.trace(s.toString(), level);
        }
    }

    static boolean verifyDocId(String id, Query query, boolean skippedEarlierResult) {
        DocumentId docId;
        String expUserId = query.properties().getString(streamingUserid);
        String expGroupName = query.properties().getString(streamingGroupname);
        LogLevel logLevel = LogLevel.ERROR;
        if (skippedEarlierResult) {
            logLevel = LogLevel.DEBUG;
        }
        try {
            docId = new DocumentId(id);
        }
        catch (IllegalArgumentException iae) {
            log.log((Level)logLevel, "Bad result for " + query + ": " + iae.getMessage());
            return false;
        }
        if (expUserId != null) {
            if (!docId.getScheme().hasNumber()) {
                log.log((Level)logLevel, "Got result with wrong scheme (expected " + IdString.Scheme.userdoc + " or " + IdString.Scheme.orderdoc + ") in document ID (" + id + ") for " + query);
                return false;
            }
            long userId = docId.getScheme().getNumber();
            if (new BigInteger(expUserId).longValue() != userId) {
                log.log((Level)logLevel, "Got result with wrong user ID (expected " + expUserId + ") in document ID (" + id + ") for " + query);
                return false;
            }
        } else if (expGroupName != null) {
            if (!docId.getScheme().hasGroup()) {
                log.log((Level)logLevel, "Got result with wrong scheme (expected " + IdString.Scheme.groupdoc + " or " + IdString.Scheme.orderdoc + ") in document ID (" + id + ") for " + query);
                return false;
            }
            String groupName = docId.getScheme().getGroup();
            if (!expGroupName.equals(groupName)) {
                log.log((Level)logLevel, "Got result with wrong group name (expected " + expGroupName + ") in document ID (" + id + ") for " + query);
                return false;
            }
        }
        return true;
    }

    @Override
    public Pong ping(Ping ping, Execution execution) {
        return new Pong();
    }

    private static class VdsVisitorFactory
    implements VisitorFactory {
        private VdsVisitorFactory() {
        }

        @Override
        public Visitor createVisitor(Query query, String searchCluster, Route route) {
            return new VdsVisitor(query, searchCluster, route);
        }
    }
}

