/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yahoo.search.yql.ExpressionOperator;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.ProgramCompileException;
import com.yahoo.search.yql.ProjectOperator;
import com.yahoo.search.yql.SequenceOperator;
import java.util.Map;
import java.util.Set;

class ProjectionBuilder {
    private Map<String, OperatorNode<ExpressionOperator>> fields = Maps.newLinkedHashMap();
    private Set<String> aliasNames = Sets.newHashSet();

    ProjectionBuilder() {
    }

    public void addField(String name, OperatorNode<ExpressionOperator> expr) {
        String aliasName = name;
        if (name == null) {
            name = this.assignName(expr);
        }
        if (this.fields.containsKey(name)) {
            throw new ProgramCompileException(expr.getLocation(), "Field alias '%s' already defined", name);
        }
        this.fields.put(name, expr);
        if (aliasName != null) {
            this.aliasNames.add(aliasName);
        }
    }

    public boolean isAlias(String name) {
        return this.aliasNames.contains(name);
    }

    private String assignName(OperatorNode<ExpressionOperator> expr) {
        String baseName = "expr";
        switch (expr.getOperator()) {
            case PROPREF: {
                baseName = (String)((Object)expr.getArgument(1));
                break;
            }
            case READ_RECORD: {
                baseName = (String)((Object)expr.getArgument(0));
                break;
            }
            case READ_FIELD: {
                baseName = (String)((Object)expr.getArgument(1));
                break;
            }
            case VARREF: {
                baseName = (String)((Object)expr.getArgument(0));
            }
        }
        int c = 0;
        String candidate = baseName;
        while (this.fields.containsKey(candidate)) {
            candidate = baseName + ++c;
        }
        return candidate;
    }

    public OperatorNode<SequenceOperator> make(OperatorNode<SequenceOperator> target) {
        ImmutableList.Builder lst = ImmutableList.builder();
        for (Map.Entry<String, OperatorNode<ExpressionOperator>> e : this.fields.entrySet()) {
            if (e.getKey().startsWith("*")) {
                lst.add(OperatorNode.create(ProjectOperator.MERGE_RECORD, (Object[])e.getValue().getArgument(0)));
                continue;
            }
            if (e.getValue().getOperator() == ExpressionOperator.READ_RECORD) {
                lst.add(OperatorNode.create(ProjectOperator.RECORD, e.getValue(), e.getKey()));
                continue;
            }
            lst.add(OperatorNode.create(ProjectOperator.FIELD, e.getValue(), e.getKey()));
        }
        return OperatorNode.create(SequenceOperator.PROJECT, target, lst.build());
    }
}

