/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yahoo.search.yql.CaseInsensitiveFileStream;
import com.yahoo.search.yql.CaseInsensitiveInputStream;
import com.yahoo.search.yql.ExpressionOperator;
import com.yahoo.search.yql.Location;
import com.yahoo.search.yql.OperatorNode;
import com.yahoo.search.yql.ProgramCompileException;
import com.yahoo.search.yql.ProjectionBuilder;
import com.yahoo.search.yql.SequenceOperator;
import com.yahoo.search.yql.SortOperator;
import com.yahoo.search.yql.StatementOperator;
import com.yahoo.search.yql.StringUnescaper;
import com.yahoo.search.yql.TypeOperator;
import com.yahoo.search.yql.yqlplusLexer;
import com.yahoo.search.yql.yqlplusParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

final class ProgramParser {
    ProgramParser() {
    }

    public yqlplusParser prepareParser(String programName, InputStream input) throws IOException {
        return this.prepareParser(programName, (CharStream)new CaseInsensitiveInputStream(input));
    }

    public yqlplusParser prepareParser(String programName, String input) throws IOException {
        return this.prepareParser(programName, (CharStream)new CaseInsensitiveInputStream(input));
    }

    public yqlplusParser prepareParser(File file) throws IOException {
        return this.prepareParser(file.getAbsoluteFile().toString(), (CharStream)new CaseInsensitiveFileStream(file.getAbsolutePath()));
    }

    private yqlplusParser prepareParser(final String programName, CharStream input) {
        yqlplusLexer lex = new yqlplusLexer(input);
        lex.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
                throw new ProgramCompileException(new Location(programName, line, charPositionInLine), msg, new Object[0]);
            }
        });
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        yqlplusParser parser = new yqlplusParser((TokenStream)tokens);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(@NotNull Recognizer<?, ?> recognizer, @Nullable Object offendingSymbol, int line, int charPositionInLine, @NotNull String msg, @Nullable RecognitionException e) {
                throw new ProgramCompileException(new Location(programName, line, charPositionInLine), msg, new Object[0]);
            }
        });
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        return parser;
    }

    private yqlplusParser.ProgramContext parseProgram(yqlplusParser parser) throws RecognitionException {
        try {
            return parser.program();
        }
        catch (RecognitionException e) {
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            return parser.program();
        }
    }

    public OperatorNode<StatementOperator> parse(String programName, InputStream program) throws IOException, RecognitionException {
        yqlplusParser parser = this.prepareParser(programName, program);
        return this.convertProgram(this.parseProgram(parser), parser, programName);
    }

    public OperatorNode<StatementOperator> parse(String programName, String program) throws IOException, RecognitionException {
        yqlplusParser parser = this.prepareParser(programName, program);
        return this.convertProgram(this.parseProgram(parser), parser, programName);
    }

    public OperatorNode<StatementOperator> parse(File input) throws IOException, RecognitionException {
        yqlplusParser parser = this.prepareParser(input);
        return this.convertProgram(this.parseProgram(parser), parser, input.getAbsoluteFile().toString());
    }

    public OperatorNode<ExpressionOperator> parseExpression(String input) throws IOException, RecognitionException {
        return this.convertExpr((ParseTree)this.prepareParser("<expression>", input).expression(false).getRuleContext(), new Scope());
    }

    public OperatorNode<ExpressionOperator> parseExpression(String input, Set<String> visibleAliases) throws IOException, RecognitionException {
        Scope scope = new Scope();
        Location loc = new Location("<expression>", -1, -1);
        for (String alias : visibleAliases) {
            scope.defineDataSource(loc, alias);
        }
        return this.convertExpr((ParseTree)this.prepareParser("<expression>", input).expression(false).getRuleContext(), scope);
    }

    private Location toLocation(Scope scope, ParseTree node) {
        Token start;
        if (node instanceof ParserRuleContext) {
            start = ((ParserRuleContext)node).start;
        } else if (node instanceof TerminalNode) {
            start = ((TerminalNode)node).getSymbol();
        } else {
            throw new ProgramCompileException("Location is not available for type " + node.getClass());
        }
        Location location = new Location(scope != null ? scope.programName : "<string>", start.getLine(), start.getCharPositionInLine());
        return location;
    }

    private List<String> readName(yqlplusParser.Namespaced_nameContext node) {
        ArrayList path = Lists.newArrayList();
        for (ParseTree elt : node.children) {
            if (ProgramParser.getParseTreeIndex(elt) == 88) continue;
            path.add(elt.getText());
        }
        return path;
    }

    private OperatorNode<SequenceOperator> convertSelectOrInsertOrUpdateOrDelete(ParseTree node, Scope scopeParent) {
        OperatorNode<ExpressionOperator> updateValues;
        OperatorNode<SequenceOperator> insertValues;
        OperatorNode<SequenceOperator> fallback;
        OperatorNode<ExpressionOperator> timeout;
        OperatorNode<ExpressionOperator> limit;
        OperatorNode<ExpressionOperator> offset;
        ArrayList orderby;
        OperatorNode<ExpressionOperator> filter;
        OperatorNode<SequenceOperator> source;
        ProjectionBuilder proj;
        Scope scope;
        block41: {
            block40: {
                Preconditions.checkArgument((node instanceof yqlplusParser.Select_statementContext || node instanceof yqlplusParser.Insert_statementContext || node instanceof yqlplusParser.Update_statementContext || node instanceof yqlplusParser.Delete_statementContext ? 1 : 0) != 0);
                scope = scopeParent.child();
                proj = null;
                source = null;
                filter = null;
                orderby = null;
                offset = null;
                limit = null;
                timeout = null;
                fallback = null;
                insertValues = null;
                updateValues = null;
                ParseTree sourceNode = node instanceof yqlplusParser.Select_statementContext ? (node.getChild(2) != null ? node.getChild(2).getChild(0) : null) : node.getChild(1);
                if (sourceNode == null) break block40;
                switch (ProgramParser.getParseTreeIndex(sourceNode)) {
                    case 33: {
                        Location location = this.toLocation(scope, sourceNode.getChild(2));
                        source = OperatorNode.create(location, SequenceOperator.ALL, new Object[0]);
                        source.putAnnotation("alias", "row");
                        scope.defineDataSource(location, "row");
                        break;
                    }
                    case 34: {
                        yqlplusParser.Source_listContext multiSourceContext = ((yqlplusParser.Select_source_multiContext)sourceNode).source_list();
                        source = this.readMultiSource(scope, multiSourceContext);
                        source.putAnnotation("alias", "row");
                        scope.defineDataSource(this.toLocation(scope, (ParseTree)multiSourceContext), "row");
                        break;
                    }
                    case 35: {
                        source = this.convertSource((ParserRuleContext)sourceNode.getChild(1), scope);
                        List<yqlplusParser.Join_exprContext> joinContexts = ((yqlplusParser.Select_source_joinContext)sourceNode).join_expr();
                        for (yqlplusParser.Join_exprContext joinContext : joinContexts) {
                            source = this.convertJoin(joinContext, source, scope);
                        }
                        break block41;
                    }
                    case 96: {
                        yqlplusParser.Insert_sourceContext insertSourceContext = (yqlplusParser.Insert_sourceContext)sourceNode;
                        source = this.convertSource((ParserRuleContext)insertSourceContext.getChild(1), scope);
                        break;
                    }
                    case 104: {
                        source = this.convertSource((ParserRuleContext)sourceNode.getChild(1), scope);
                        break;
                    }
                    case 106: {
                        source = this.convertSource((ParserRuleContext)sourceNode.getChild(0), scope);
                    }
                }
                break block41;
            }
            source = OperatorNode.create(SequenceOperator.EMPTY, new Object[0]);
        }
        block21: for (int i = 1; i < node.getChildCount(); ++i) {
            ParseTree child = node.getChild(i);
            switch (ProgramParser.getParseTreeIndex(child)) {
                case 28: {
                    if (ProgramParser.getParseTreeIndex(child.getChild(0)) != 29) continue block21;
                    proj = this.readProjection(((yqlplusParser.Project_specContext)child.getChild(0)).field_def(), scope);
                    continue block21;
                }
                case 102: {
                    proj = this.readProjection(((yqlplusParser.Returning_specContext)child).select_field_spec().project_spec().field_def(), scope);
                    continue block21;
                }
                case 50: {
                    filter = this.convertExpr((ParseTree)((yqlplusParser.WhereContext)child).expression(), scope);
                    continue block21;
                }
                case 45: {
                    List<yqlplusParser.Orderby_fieldContext> orderFieds = ((yqlplusParser.OrderbyContext)child).orderby_fields().orderby_field();
                    orderby = Lists.newArrayListWithExpectedSize((int)orderFieds.size());
                    for (int j = 0; j < orderFieds.size(); ++j) {
                        orderby.add(this.convertSortKey(orderFieds.get(j), scope));
                    }
                    continue block21;
                }
                case 48: {
                    limit = this.convertExpr((ParseTree)((yqlplusParser.LimitContext)child).fixed_or_parameter(), scope);
                    continue block21;
                }
                case 49: {
                    offset = this.convertExpr((ParseTree)((yqlplusParser.OffsetContext)child).fixed_or_parameter(), scope);
                    continue block21;
                }
                case 31: {
                    timeout = this.convertExpr((ParseTree)((yqlplusParser.TimeoutContext)child).fixed_or_parameter(), scope);
                    continue block21;
                }
                case 30: {
                    fallback = this.convertQuery((ParseTree)((yqlplusParser.FallbackContext)child).select_statement(), scope);
                    continue block21;
                }
                case 98: {
                    if (child.getChild(0) instanceof yqlplusParser.Query_statementContext) {
                        insertValues = this.convertQuery(child.getChild(0).getChild(0), scope);
                        continue block21;
                    }
                    insertValues = this.readBatchValues(((yqlplusParser.Insert_valuesContext)child).field_names_spec(), ((yqlplusParser.Insert_valuesContext)child).field_values_group_spec(), scope);
                    continue block21;
                }
                case 107: {
                    updateValues = ProgramParser.getParseTreeIndex(child.getChild(0)) == 51 ? this.readValues(((yqlplusParser.Update_valuesContext)child).field_def(), scope) : this.readValues((yqlplusParser.Field_names_specContext)child.getChild(0), (yqlplusParser.Field_values_specContext)child.getChild(2), scope);
                }
            }
        }
        OperatorNode<SequenceOperator> result = source;
        if (filter != null) {
            result = OperatorNode.create(SequenceOperator.FILTER, result, filter);
        }
        if (insertValues != null) {
            result = OperatorNode.create(SequenceOperator.INSERT, result, insertValues);
        }
        if (updateValues != null) {
            result = filter != null ? OperatorNode.create(SequenceOperator.UPDATE, source, updateValues, filter) : OperatorNode.create(SequenceOperator.UPDATE_ALL, source, updateValues);
        }
        if (ProgramParser.getParseTreeIndex(node) == 103) {
            result = filter != null ? OperatorNode.create(SequenceOperator.DELETE, source, filter) : OperatorNode.create(SequenceOperator.DELETE_ALL, source);
        }
        boolean projectBeforeSort = false;
        if (orderby != null) {
            if (proj != null) {
                block23: for (OperatorNode sortKey : orderby) {
                    OperatorNode sortExpression = (OperatorNode)sortKey.getArgument(0);
                    List<OperatorNode<ExpressionOperator>> sortReadFields = this.getReadFieldExpressions(sortExpression);
                    for (OperatorNode<ExpressionOperator> sortReadField : sortReadFields) {
                        String sortKeyField = (String)((Object)sortReadField.getArgument(1));
                        if (!proj.isAlias(sortKeyField)) continue;
                        projectBeforeSort = true;
                        continue block23;
                    }
                }
            }
            result = projectBeforeSort ? OperatorNode.create(SequenceOperator.SORT, proj.make(result), orderby) : OperatorNode.create(SequenceOperator.SORT, result, orderby);
        }
        if (offset != null && limit != null) {
            result = OperatorNode.create(SequenceOperator.SLICE, result, offset, limit);
        } else if (offset != null) {
            result = OperatorNode.create(SequenceOperator.OFFSET, result, offset);
        } else if (limit != null) {
            result = OperatorNode.create(SequenceOperator.LIMIT, result, limit);
        }
        if (proj != null && !projectBeforeSort) {
            result = proj.make(result);
        }
        if (timeout != null) {
            result = OperatorNode.create(SequenceOperator.TIMEOUT, result, timeout);
        }
        if (fallback != null) {
            result = OperatorNode.create(SequenceOperator.FALLBACK, result, fallback);
        }
        return result;
    }

    private OperatorNode<ExpressionOperator> readValues(List<yqlplusParser.Field_defContext> fieldDefs, Scope scope) {
        int numPairs = fieldDefs.size();
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)numPairs);
        ArrayList fieldValues = Lists.newArrayListWithExpectedSize((int)numPairs);
        for (int j = 0; j < numPairs; ++j) {
            ParseTree startNode = (ParseTree)fieldDefs.get(j);
            while (startNode.getChildCount() < 3) {
                startNode = startNode.getChild(0);
            }
            fieldNames.add((String)((Object)this.convertExpr(startNode.getChild(0), scope).getArgument(1)));
            fieldValues.add(this.convertExpr(startNode.getChild(2), scope));
        }
        return OperatorNode.create(ExpressionOperator.MAP, fieldNames, fieldValues);
    }

    private OperatorNode<SequenceOperator> readMultiSource(Scope scope, yqlplusParser.Source_listContext multiSource) {
        ArrayList sourceNameList = Lists.newArrayList();
        List<yqlplusParser.Namespaced_nameContext> nameSpaces = multiSource.namespaced_name();
        for (yqlplusParser.Namespaced_nameContext node : nameSpaces) {
            List<String> name = this.readName(node);
            sourceNameList.add(name);
        }
        return OperatorNode.create(this.toLocation(scope, (ParseTree)multiSource), SequenceOperator.MULTISOURCE, sourceNameList);
    }

    private OperatorNode<SequenceOperator> convertPipe(yqlplusParser.Query_statementContext queryStatementContext, List<yqlplusParser.Pipeline_stepContext> nodes, Scope scope) {
        OperatorNode<SequenceOperator> result = this.convertQuery(queryStatementContext.getChild(0), scope.getRoot());
        for (yqlplusParser.Pipeline_stepContext step : nodes) {
            yqlplusParser.ArgumentsContext arguments;
            if (ProgramParser.getParseTreeIndex(step.getChild(0)) == 18) {
                result = OperatorNode.create(SequenceOperator.PIPE, result, ImmutableList.of(), ImmutableList.of(this.convertExpr(step.getChild(0), scope)));
                continue;
            }
            List<String> name = this.readName(step.namespaced_name());
            Object args = ImmutableList.of();
            if (step.getChildCount() > 1 && (arguments = step.arguments()).getChildCount() > 2) {
                List<yqlplusParser.ArgumentContext> argumentContextList = arguments.argument();
                args = Lists.newArrayListWithExpectedSize((int)argumentContextList.size());
                for (yqlplusParser.ArgumentContext argumentContext : argumentContextList) {
                    args.add(this.convertExpr((ParseTree)argumentContext.expression(), scope.getRoot()));
                }
            }
            result = OperatorNode.create(SequenceOperator.PIPE, result, scope.resolvePath(name), args);
        }
        return result;
    }

    private OperatorNode<SequenceOperator> convertMerge(List<yqlplusParser.Merge_componentContext> mergeComponentList, Scope scope) {
        Preconditions.checkArgument((mergeComponentList != null ? 1 : 0) != 0);
        ArrayList sources = Lists.newArrayListWithExpectedSize((int)mergeComponentList.size());
        for (yqlplusParser.Merge_componentContext mergeComponent : mergeComponentList) {
            yqlplusParser.Select_statementContext selectContext = mergeComponent.select_statement();
            yqlplusParser.Source_statementContext sourceContext = mergeComponent.source_statement();
            if (selectContext != null) {
                sources.add(this.convertQuery((ParseTree)selectContext, scope.getRoot()));
                continue;
            }
            sources.add(this.convertQuery((ParseTree)sourceContext, scope.getRoot()));
        }
        return OperatorNode.create(SequenceOperator.MERGE, sources);
    }

    private OperatorNode<SequenceOperator> convertQuery(ParseTree node, Scope scope) {
        if (node instanceof yqlplusParser.Select_statementContext || node instanceof yqlplusParser.Insert_statementContext || node instanceof yqlplusParser.Update_statementContext || node instanceof yqlplusParser.Delete_statementContext) {
            return this.convertSelectOrInsertOrUpdateOrDelete(node, scope.getRoot());
        }
        if (node instanceof yqlplusParser.Source_statementContext) {
            yqlplusParser.Source_statementContext sourceStatementContext = (yqlplusParser.Source_statementContext)node;
            return this.convertPipe(sourceStatementContext.query_statement(), sourceStatementContext.pipeline_step(), scope);
        }
        if (node instanceof yqlplusParser.Merge_statementContext) {
            return this.convertMerge(((yqlplusParser.Merge_statementContext)node).merge_component(), scope);
        }
        throw new IllegalArgumentException("Unexpected argument type to convertQueryStatement: " + node.toStringTree());
    }

    private OperatorNode<SequenceOperator> convertJoin(yqlplusParser.Join_exprContext node, OperatorNode<SequenceOperator> left, Scope scope) {
        yqlplusParser.Source_specContext sourceSpec = node.source_spec();
        OperatorNode<SequenceOperator> right = this.convertSource(sourceSpec, scope);
        yqlplusParser.JoinExpressionContext joinContext = node.joinExpression();
        OperatorNode<ExpressionOperator> joinExpression = this.readBinOp(ExpressionOperator.valueOf("EQ"), joinContext.getChild(0), joinContext.getChild(2), scope);
        if (joinExpression.getOperator() != ExpressionOperator.EQ) {
            throw new ProgramCompileException(joinExpression.getLocation(), "Unexpected join expression type: %s (expected EQ)", joinExpression.getOperator());
        }
        return OperatorNode.create(this.toLocation(scope, (ParseTree)sourceSpec), node.join_spec().LEFT() != null ? SequenceOperator.LEFT_JOIN : SequenceOperator.JOIN, left, right, joinExpression);
    }

    private String assignAlias(String alias, ParserRuleContext node, Scope scope) {
        if (alias == null) {
            alias = "source";
        }
        if (node != null && node instanceof yqlplusParser.Alias_defContext) {
            ParserRuleContext idChild = node;
            if (node.getChildCount() > 1) {
                idChild = node.getChild(1);
            }
            if (scope.isCursor(alias = idChild.getText())) {
                throw new ProgramCompileException(this.toLocation(scope, (ParseTree)idChild), "Source alias '%s' is already used", alias);
            }
            scope.defineDataSource(this.toLocation(scope, (ParseTree)idChild), alias);
            return alias;
        }
        String candidate = alias;
        int c = 0;
        while (scope.isCursor(candidate)) {
            candidate = alias + ++c;
        }
        scope.defineDataSource(null, candidate);
        return alias;
    }

    private OperatorNode<SequenceOperator> convertSource(ParserRuleContext sourceSpecNode, Scope scope) {
        OperatorNode<SequenceOperator> result;
        String alias;
        ParserRuleContext dataSourceNode = sourceSpecNode;
        ParserRuleContext aliasContext = null;
        if (sourceSpecNode instanceof yqlplusParser.Source_specContext) {
            dataSourceNode = (ParserRuleContext)sourceSpecNode.getChild(0);
            if (sourceSpecNode.getChildCount() == 2) {
                aliasContext = (ParserRuleContext)sourceSpecNode.getChild(1);
            }
            dataSourceNode = dataSourceNode.getChild(0) instanceof yqlplusParser.Call_sourceContext || dataSourceNode.getChild(0) instanceof yqlplusParser.Sequence_sourceContext ? (ParserRuleContext)dataSourceNode.getChild(0) : (ParserRuleContext)dataSourceNode.getChild(1);
        }
        switch (ProgramParser.getParseTreeIndex((ParseTree)dataSourceNode)) {
            case 42: 
            case 97: {
                List<String> names = this.readName((yqlplusParser.Namespaced_nameContext)dataSourceNode.getChild(yqlplusParser.Namespaced_nameContext.class, 0));
                alias = this.assignAlias(names.get(names.size() - 1), aliasContext, scope);
                Object arguments = ImmutableList.of();
                yqlplusParser.ArgumentsContext argumentsContext = (yqlplusParser.ArgumentsContext)dataSourceNode.getRuleContext(yqlplusParser.ArgumentsContext.class, 0);
                if (argumentsContext != null) {
                    List<yqlplusParser.ArgumentContext> argumentContexts = argumentsContext.argument();
                    arguments = Lists.newArrayListWithExpectedSize((int)argumentContexts.size());
                    for (yqlplusParser.ArgumentContext argumentContext : argumentContexts) {
                        arguments.add(this.convertExpr((ParseTree)argumentContext, scope));
                    }
                }
                if (names.size() == 1 && scope.isVariable(names.get(0))) {
                    String ident = names.get(0);
                    if (arguments.size() > 0) {
                        throw new ProgramCompileException(this.toLocation(scope, (ParseTree)argumentsContext), "Invalid call-with-arguments on local source '%s'", ident);
                    }
                    result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.EVALUATE, OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), ExpressionOperator.VARREF, ident));
                    break;
                }
                result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.SCAN, scope.resolvePath(names), arguments);
                break;
            }
            case 43: {
                yqlplusParser.IdentContext identContext = (yqlplusParser.IdentContext)dataSourceNode.getRuleContext(yqlplusParser.IdentContext.class, 0);
                String ident = identContext.getText();
                if (!scope.isVariable(ident)) {
                    throw new ProgramCompileException(this.toLocation(scope, (ParseTree)identContext), "Unknown variable reference '%s'", ident);
                }
                alias = this.assignAlias(ident, aliasContext, scope);
                result = OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), SequenceOperator.EVALUATE, OperatorNode.create(this.toLocation(scope, (ParseTree)dataSourceNode), ExpressionOperator.VARREF, ident));
                break;
            }
            case 16: {
                alias = this.assignAlias(null, dataSourceNode, scope);
                result = this.convertQuery((ParseTree)dataSourceNode, scope);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected argument type to convertSource: " + dataSourceNode.getText());
            }
        }
        result.putAnnotation("alias", alias);
        return result;
    }

    private OperatorNode<TypeOperator> decodeType(Scope scope, yqlplusParser.TypenameContext type) {
        TypeOperator op;
        ParseTree typeNode = type.getChild(0);
        switch (ProgramParser.getParseTreeIndex(typeNode)) {
            case 56: {
                op = TypeOperator.BOOLEAN;
                break;
            }
            case 49: {
                op = TypeOperator.BYTE;
                break;
            }
            case 54: {
                op = TypeOperator.DOUBLE;
                break;
            }
            case 50: {
                op = TypeOperator.INT16;
                break;
            }
            case 51: {
                op = TypeOperator.INT32;
                break;
            }
            case 52: {
                op = TypeOperator.INT64;
                break;
            }
            case 53: {
                op = TypeOperator.STRING;
                break;
            }
            case 55: {
                op = TypeOperator.TIMESTAMP;
                break;
            }
            case 21: {
                return OperatorNode.create(this.toLocation(scope, typeNode), TypeOperator.ARRAY, this.decodeType(scope, (yqlplusParser.TypenameContext)((yqlplusParser.ArrayTypeContext)typeNode).getChild(yqlplusParser.TypenameContext.class, 0)));
            }
            case 22: {
                return OperatorNode.create(this.toLocation(scope, typeNode), TypeOperator.MAP, this.decodeType(scope, (yqlplusParser.TypenameContext)((yqlplusParser.MapTypeContext)typeNode).getChild(yqlplusParser.TypenameContext.class, 0)));
            }
            default: {
                throw new ProgramCompileException("Unknown type " + typeNode.getText());
            }
        }
        return OperatorNode.create(this.toLocation(scope, typeNode), op, new Object[0]);
    }

    private List<String> createBindingName(ParseTree node) {
        if (node instanceof yqlplusParser.ModuleNameContext) {
            if (((yqlplusParser.ModuleNameContext)node).namespaced_name() != null) {
                return this.readName(((yqlplusParser.ModuleNameContext)node).namespaced_name());
            }
            if (((yqlplusParser.ModuleNameContext)node).literalString() != null) {
                return ImmutableList.of((Object)((yqlplusParser.ModuleNameContext)node).literalString().STRING().getText());
            }
        } else if (node instanceof yqlplusParser.ModuleIdContext) {
            return ImmutableList.of((Object)node.getText());
        }
        throw new ProgramCompileException("Wrong context");
    }

    private OperatorNode<StatementOperator> convertProgram(ParserRuleContext program, yqlplusParser parser, String programName) {
        Scope scope = new Scope(parser, programName);
        ArrayList stmts = Lists.newArrayList();
        int output = 0;
        block16: for (ParseTree node : program.children) {
            if (!(node instanceof ParserRuleContext)) continue;
            ParserRuleContext ruleContext = (ParserRuleContext)node;
            block0 : switch (ruleContext.getRuleIndex()) {
                case 3: {
                    yqlplusParser.ParamsContext paramsContext = (yqlplusParser.ParamsContext)ruleContext;
                    yqlplusParser.Program_arglistContext program_arglistContext = paramsContext.program_arglist();
                    if (program_arglistContext == null) continue block16;
                    List<yqlplusParser.Procedure_argumentContext> argList = program_arglistContext.procedure_argument();
                    for (yqlplusParser.Procedure_argumentContext procedureArgumentContext : argList) {
                        String name = procedureArgumentContext.ident().getText();
                        Iterator type = this.decodeType(scope, (yqlplusParser.TypenameContext)procedureArgumentContext.getChild(yqlplusParser.TypenameContext.class, 0));
                        OperatorNode<ExpressionOperator> defaultValue = OperatorNode.create(ExpressionOperator.NULL, new Object[0]);
                        if (procedureArgumentContext.expression() != null) {
                            defaultValue = this.convertExpr((ParseTree)procedureArgumentContext.expression(), scope);
                        }
                        scope.defineVariable(this.toLocation(scope, (ParseTree)procedureArgumentContext), name);
                        stmts.add(OperatorNode.create(StatementOperator.ARGUMENT, name, type, defaultValue));
                    }
                    continue block16;
                }
                case 4: {
                    Location location;
                    yqlplusParser.Import_statementContext importContext = (yqlplusParser.Import_statementContext)ruleContext;
                    if (null == importContext.import_list()) {
                        String target;
                        List<String> name = this.createBindingName(node.getChild(1));
                        location = this.toLocation(scope, node.getChild(1));
                        if (node.getChildCount() == 2) {
                            target = name.get(0);
                        } else if (node.getChildCount() == 4) {
                            target = node.getChild(3).getText();
                        } else {
                            throw new ProgramCompileException("Unknown node count for IMPORT: " + node.toStringTree());
                        }
                        scope.bindModule(location, name, target);
                        break;
                    }
                    yqlplusParser.Import_listContext importListContext = importContext.import_list();
                    List<String> name = this.createBindingName((ParseTree)importContext.moduleName());
                    location = this.toLocation(scope, (ParseTree)importContext.moduleName());
                    List<yqlplusParser.ModuleIdContext> moduleIds = importListContext.moduleId();
                    ArrayList symbols = Lists.newArrayListWithExpectedSize((int)moduleIds.size());
                    for (yqlplusParser.ModuleIdContext cnode : moduleIds) {
                        symbols.add(cnode.ID().getText());
                    }
                    for (String sym : symbols) {
                        scope.bindModuleSymbol(location, name, sym, sym);
                    }
                    continue block16;
                }
                case 8: {
                    ruleContext = (ParserRuleContext)ruleContext.getChild(0);
                    break;
                }
                case 9: {
                    yqlplusParser.ViewContext viewContext = (yqlplusParser.ViewContext)ruleContext;
                    Location loc = this.toLocation(scope, (ParseTree)viewContext);
                    scope.getRoot().defineView(loc, viewContext.ID().getText());
                    stmts.add(OperatorNode.create(loc, StatementOperator.DEFINE_VIEW, viewContext.ID().getText(), this.convertQuery((ParseTree)viewContext.source_statement(), scope.getRoot())));
                    break;
                }
                case 12: {
                    yqlplusParser.StatementContext statementContext = (yqlplusParser.StatementContext)ruleContext;
                    switch (ProgramParser.getParseTreeIndex(ruleContext.getChild(0))) {
                        case 19: {
                            yqlplusParser.Selectvar_statementContext selectVarContext = (yqlplusParser.Selectvar_statementContext)ruleContext.getChild(0);
                            String variable = selectVarContext.ident().getText();
                            OperatorNode<SequenceOperator> query = this.convertQuery((ParseTree)selectVarContext.source_statement(), scope);
                            Location location = this.toLocation(scope, (ParseTree)selectVarContext.ident());
                            scope.defineVariable(location, variable);
                            stmts.add(OperatorNode.create(location, StatementOperator.EXECUTE, query, variable));
                            break block0;
                        }
                        case 15: {
                            yqlplusParser.Next_statementContext nextStateContext = (yqlplusParser.Next_statementContext)ruleContext.getChild(0);
                            String continuationValue = StringUnescaper.unquote(nextStateContext.literalString().getText());
                            String variable = nextStateContext.ident().getText();
                            Location location = this.toLocation(scope, node);
                            OperatorNode<SequenceOperator> next = OperatorNode.create(location, SequenceOperator.NEXT, continuationValue);
                            stmts.add(OperatorNode.create(location, StatementOperator.EXECUTE, next, variable));
                            stmts.add(OperatorNode.create(location, StatementOperator.OUTPUT, variable));
                            scope.defineVariable(location, variable);
                            break block0;
                        }
                        case 13: {
                            yqlplusParser.Source_statementContext source_statement = statementContext.output_statement().source_statement();
                            OperatorNode<SequenceOperator> query = source_statement.getChildCount() == 1 ? this.convertQuery(source_statement.query_statement().getChild(0), scope) : this.convertQuery((ParseTree)source_statement, scope);
                            String variable = "result" + ++output;
                            boolean isCountVariable = false;
                            OperatorNode<ExpressionOperator> pageSize = null;
                            ParseTree outputStatement = node.getChild(0);
                            Location location = this.toLocation(scope, outputStatement);
                            block20: for (int i = 1; i < outputStatement.getChildCount(); ++i) {
                                ParseTree child = outputStatement.getChild(i);
                                switch (ProgramParser.getParseTreeIndex(child)) {
                                    case 14: {
                                        yqlplusParser.Paged_clauseContext pagedContext = (yqlplusParser.Paged_clauseContext)child;
                                        pageSize = this.convertExpr((ParseTree)pagedContext.fixed_or_parameter(), scope);
                                        continue block20;
                                    }
                                    case 23: {
                                        yqlplusParser.Output_specContext outputSpecContext = (yqlplusParser.Output_specContext)child;
                                        variable = outputSpecContext.ident().getText();
                                        if (outputSpecContext.COUNT() == null) continue block20;
                                        isCountVariable = true;
                                        continue block20;
                                    }
                                    default: {
                                        throw new ProgramCompileException("Unknown statement attribute: " + child.toStringTree());
                                    }
                                }
                            }
                            scope.defineVariable(location, variable);
                            if (pageSize != null) {
                                query = OperatorNode.create(SequenceOperator.PAGE, query, pageSize);
                            }
                            stmts.add(OperatorNode.create(location, StatementOperator.EXECUTE, query, variable));
                            stmts.add(OperatorNode.create(location, isCountVariable ? StatementOperator.COUNT : StatementOperator.OUTPUT, variable));
                        }
                    }
                    break;
                }
                default: {
                    throw new ProgramCompileException("Unknown program element: " + node.getText());
                }
            }
        }
        return OperatorNode.create(StatementOperator.PROGRAM, stmts);
    }

    private OperatorNode<SortOperator> convertSortKey(yqlplusParser.Orderby_fieldContext node, Scope scope) {
        TerminalNode descDef = node.DESC();
        OperatorNode<ExpressionOperator> exprNode = this.convertExpr((ParseTree)node.expression(), scope);
        if (descDef != null) {
            return OperatorNode.create(this.toLocation(scope, (ParseTree)descDef), SortOperator.DESC, exprNode);
        }
        return OperatorNode.create(this.toLocation(scope, (ParseTree)node), SortOperator.ASC, exprNode);
    }

    private ProjectionBuilder readProjection(List<yqlplusParser.Field_defContext> fieldDefs, Scope scope) {
        if (null == fieldDefs) {
            throw new ProgramCompileException("Null fieldDefs");
        }
        ProjectionBuilder proj = new ProjectionBuilder();
        for (yqlplusParser.Field_defContext rulenode : fieldDefs) {
            OperatorNode<ExpressionOperator> expr = this.convertExpr((ParseTree)((yqlplusParser.ExpressionContext)rulenode.getChild(0)), scope);
            String aliasName = null;
            if (rulenode.getChildCount() > 1) {
                aliasName = rulenode.alias_def().ID().getText();
            }
            proj.addField(aliasName, expr);
        }
        return proj;
    }

    public static int getParseTreeIndex(ParseTree parseTree) {
        if (parseTree instanceof TerminalNode) {
            return ((TerminalNode)parseTree).getSymbol().getType();
        }
        return ((RuleNode)parseTree).getRuleContext().getRuleIndex();
    }

    public OperatorNode<ExpressionOperator> convertExpr(ParseTree parseTree, Scope scope) {
        switch (ProgramParser.getParseTreeIndex(parseTree)) {
            case 18: {
                ParseTree firstChild = parseTree.getChild(0);
                if (ProgramParser.getParseTreeIndex(firstChild) == 61) {
                    ParseTree secondChild = parseTree.getChild(1);
                    OperatorNode<ExpressionOperator> annotation = this.convertExpr((ParseTree)((yqlplusParser.AnnotationContext)firstChild).constantMapExpression(), scope);
                    OperatorNode<ExpressionOperator> expr = OperatorNode.create(this.toLocation(scope, secondChild), ExpressionOperator.VESPA_GROUPING, secondChild.getText());
                    List names = (List)((Object)annotation.getArgument(0));
                    List annotates = (List)((Object)annotation.getArgument(1));
                    for (int i = 0; i < names.size(); ++i) {
                        expr.putAnnotation((String)names.get(i), this.readConstantExpression((OperatorNode)annotates.get(i)));
                    }
                    return expr;
                }
                return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.VESPA_GROUPING, firstChild.getText());
            }
            case 59: {
                return OperatorNode.create(ExpressionOperator.NULL, new Object[0]);
            }
            case 55: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 94: {
                ParseTree firstChild = parseTree.getChild(0);
                if (ProgramParser.getParseTreeIndex(firstChild) == 97) {
                    return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.LITERAL, new Integer(firstChild.getText()));
                }
                return this.convertExpr(firstChild, scope);
            }
            case 53: {
                List<yqlplusParser.ConstantPropertyNameAndValueContext> propertyList = ((yqlplusParser.ConstantMapExpressionContext)parseTree).constantPropertyNameAndValue();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                ArrayList exprs = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                for (yqlplusParser.ConstantPropertyNameAndValueContext child : propertyList) {
                    names.add(StringUnescaper.unquote(child.getChild(0).getText()));
                    exprs.add(this.convertExpr(child.getChild(2), scope));
                }
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.MAP, names, exprs);
            }
            case 52: {
                List<yqlplusParser.PropertyNameAndValueContext> propertyList = ((yqlplusParser.MapExpressionContext)parseTree).propertyNameAndValue();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)propertyList.size());
                ArrayList exprs = Lists.newArrayListWithCapacity((int)propertyList.size());
                for (yqlplusParser.PropertyNameAndValueContext child : propertyList) {
                    names.add(StringUnescaper.unquote(child.getChild(0).getText()));
                    exprs.add(this.convertExpr(child.getChild(2), scope));
                }
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.MAP, names, exprs);
            }
            case 88: {
                List<yqlplusParser.ConstantExpressionContext> expressionList = ((yqlplusParser.ConstantArrayContext)parseTree).constantExpression();
                ArrayList values = Lists.newArrayListWithExpectedSize((int)expressionList.size());
                for (yqlplusParser.ConstantExpressionContext expr : expressionList) {
                    values.add(this.convertExpr((ParseTree)expr, scope));
                }
                return OperatorNode.create(this.toLocation(scope, expressionList.isEmpty() ? parseTree : (ParseTree)expressionList.get(0)), ExpressionOperator.ARRAY, values);
            }
            case 82: {
                List<yqlplusParser.ExpressionContext> expressionList = ((yqlplusParser.ArrayLiteralContext)parseTree).expression();
                ArrayList values = Lists.newArrayListWithExpectedSize((int)expressionList.size());
                for (yqlplusParser.ExpressionContext expr : expressionList) {
                    values.add(this.convertExpr((ParseTree)expr, scope));
                }
                return OperatorNode.create(this.toLocation(scope, expressionList.isEmpty() ? parseTree : (ParseTree)expressionList.get(0)), ExpressionOperator.ARRAY, values);
            }
            case 75: {
                yqlplusParser.DereferencedExpressionContext dereferencedExpression = (yqlplusParser.DereferencedExpressionContext)parseTree;
                Iterator it = dereferencedExpression.children.iterator();
                OperatorNode<ExpressionOperator> result = this.convertExpr((ParseTree)it.next(), scope);
                while (it.hasNext()) {
                    ParseTree defTree = (ParseTree)it.next();
                    if (ProgramParser.getParseTreeIndex(defTree) == 77) {
                        result = OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.PROPREF, result, defTree.getChild(1).getText());
                        continue;
                    }
                    result = OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.INDEX, result, this.convertExpr(defTree.getChild(1), scope));
                }
                return result;
            }
            case 79: {
                ParseTree firstChild = parseTree.getChild(0);
                switch (ProgramParser.getParseTreeIndex(firstChild)) {
                    case 81: {
                        return this.convertExpr(firstChild, scope);
                    }
                    case 80: {
                        List<yqlplusParser.ArgumentContext> args = ((yqlplusParser.ArgumentsContext)firstChild.getChild(1)).argument();
                        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)args.size());
                        for (yqlplusParser.ArgumentContext argContext : args) {
                            arguments.add(this.convertExpr((ParseTree)argContext.expression(), scope));
                        }
                        return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.CALL, scope.resolvePath(this.readName((yqlplusParser.Namespaced_nameContext)firstChild.getChild(0))), arguments);
                    }
                    case 83: {
                        return OperatorNode.create(this.toLocation(scope, firstChild), ExpressionOperator.VARREF, firstChild.getChild(1).getText());
                    }
                    case 52: 
                    case 82: 
                    case 89: {
                        return this.convertExpr(firstChild, scope);
                    }
                    case 61: {
                        return this.convertExpr(parseTree.getChild(1), scope);
                    }
                }
                break;
            }
            case 83: {
                ParserRuleContext parameterContext = (ParserRuleContext)parseTree;
                yqlplusParser.IdentContext identContext = (yqlplusParser.IdentContext)parameterContext.getRuleContext(yqlplusParser.IdentContext.class, 0);
                return OperatorNode.create(this.toLocation(scope, (ParseTree)identContext), ExpressionOperator.VARREF, identContext.getText());
            }
            case 60: {
                yqlplusParser.AnnotationContext annotateExpressionContext = ((yqlplusParser.AnnotateExpressionContext)parseTree).annotation();
                OperatorNode<ExpressionOperator> annotation = this.convertExpr((ParseTree)annotateExpressionContext.constantMapExpression(), scope);
                OperatorNode<ExpressionOperator> expr = this.convertExpr(parseTree.getChild(1), scope);
                List names = (List)((Object)annotation.getArgument(0));
                List annotates = (List)((Object)annotation.getArgument(1));
                for (int i = 0; i < names.size(); ++i) {
                    expr.putAnnotation((String)names.get(i), this.readConstantExpression((OperatorNode)annotates.get(i)));
                }
                return expr;
            }
            case 58: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 63: {
                yqlplusParser.LogicalANDExpressionContext andExpressionContext = (yqlplusParser.LogicalANDExpressionContext)parseTree;
                return this.readConjOp(ExpressionOperator.AND, andExpressionContext.equalityExpression(), scope);
            }
            case 62: {
                int childCount = parseTree.getChildCount();
                yqlplusParser.LogicalORExpressionContext logicalORExpressionContext = (yqlplusParser.LogicalORExpressionContext)parseTree;
                if (childCount > 1) {
                    return this.readConjOrOp(ExpressionOperator.OR, logicalORExpressionContext, scope);
                }
                List<yqlplusParser.EqualityExpressionContext> equalityExpressionList = ((yqlplusParser.LogicalANDExpressionContext)parseTree.getChild(0)).equalityExpression();
                if (equalityExpressionList.size() > 1) {
                    return this.readConjOp(ExpressionOperator.AND, equalityExpressionList, scope);
                }
                return this.convertExpr((ParseTree)equalityExpressionList.get(0), scope);
            }
            case 64: {
                yqlplusParser.EqualityExpressionContext equalityExpression = (yqlplusParser.EqualityExpressionContext)parseTree;
                yqlplusParser.RelationalExpressionContext relationalExpressionContext = equalityExpression.relationalExpression(0);
                OperatorNode<ExpressionOperator> expr = this.convertExpr((ParseTree)relationalExpressionContext, scope);
                yqlplusParser.InNotInTargetContext inNotInTarget = equalityExpression.inNotInTarget();
                int childCount = equalityExpression.getChildCount();
                if (childCount == 1) {
                    return expr;
                }
                if (inNotInTarget != null) {
                    boolean isIN;
                    yqlplusParser.Literal_listContext literalListContext = inNotInTarget.literal_list();
                    boolean bl = isIN = equalityExpression.IN() != null;
                    if (literalListContext == null) {
                        yqlplusParser.Select_statementContext selectStatementContext = inNotInTarget.select_statement();
                        OperatorNode<SequenceOperator> query = this.convertQuery((ParseTree)selectStatementContext, scope);
                        return OperatorNode.create(expr.getLocation(), isIN ? ExpressionOperator.IN_QUERY : ExpressionOperator.NOT_IN_QUERY, expr, query);
                    }
                    return this.readBinOp(isIN ? ExpressionOperator.IN : ExpressionOperator.NOT_IN, equalityExpression.getChild(0), (ParseTree)literalListContext, scope);
                }
                ParseTree firstChild = equalityExpression.getChild(1);
                if (equalityExpression.getChildCount() == 2) {
                    switch (ProgramParser.getParseTreeIndex(firstChild)) {
                        case 86: {
                            return this.readUnOp(ExpressionOperator.IS_NULL, (ParseTree)relationalExpressionContext, scope);
                        }
                        case 87: {
                            return this.readUnOp(ExpressionOperator.IS_NOT_NULL, (ParseTree)relationalExpressionContext, scope);
                        }
                    }
                    break;
                }
                switch (ProgramParser.getParseTreeIndex(firstChild.getChild(0))) {
                    case 80: {
                        return this.readBinOp(ExpressionOperator.EQ, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 78: {
                        return this.readBinOp(ExpressionOperator.NEQ, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 81: {
                        return this.readBinOp(ExpressionOperator.LIKE, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 83: {
                        return this.readBinOp(ExpressionOperator.NOT_LIKE, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 84: {
                        return this.readBinOp(ExpressionOperator.MATCHES, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 85: {
                        return this.readBinOp(ExpressionOperator.NOT_MATCHES, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                    case 82: {
                        return this.readBinOp(ExpressionOperator.CONTAINS, equalityExpression.getChild(0), equalityExpression.getChild(2), scope);
                    }
                }
                break;
            }
            case 67: {
                yqlplusParser.RelationalExpressionContext relationalExpressionContext = (yqlplusParser.RelationalExpressionContext)parseTree;
                yqlplusParser.RelationalOpContext opContext = relationalExpressionContext.relationalOp();
                if (opContext != null) {
                    switch (ProgramParser.getParseTreeIndex(relationalExpressionContext.relationalOp().getChild(0))) {
                        case 74: {
                            return this.readBinOp(ExpressionOperator.LT, parseTree, scope);
                        }
                        case 76: {
                            return this.readBinOp(ExpressionOperator.LTEQ, parseTree, scope);
                        }
                        case 75: {
                            return this.readBinOp(ExpressionOperator.GT, parseTree, scope);
                        }
                        case 77: {
                            return this.readBinOp(ExpressionOperator.GTEQ, parseTree, scope);
                        }
                    }
                    break;
                }
                return this.convertExpr((ParseTree)relationalExpressionContext.additiveExpression(0), scope);
            }
            case 69: 
            case 71: {
                if (parseTree.getChildCount() > 1) {
                    String opStr;
                    switch (opStr = parseTree.getChild(1).getText()) {
                        case "+": {
                            return this.readBinOp(ExpressionOperator.ADD, parseTree, scope);
                        }
                        case "-": {
                            return this.readBinOp(ExpressionOperator.SUB, parseTree, scope);
                        }
                        case "/": {
                            return this.readBinOp(ExpressionOperator.DIV, parseTree, scope);
                        }
                        case "*": {
                            return this.readBinOp(ExpressionOperator.MULT, parseTree, scope);
                        }
                        case "%": {
                            return this.readBinOp(ExpressionOperator.MOD, parseTree, scope);
                        }
                    }
                    if (parseTree.getChild(0) instanceof yqlplusParser.UnaryExpressionContext) {
                        return this.convertExpr(parseTree.getChild(0), scope);
                    }
                    throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.toStringTree(), new Object[0]);
                }
                if (parseTree.getChild(0) instanceof yqlplusParser.UnaryExpressionContext) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                if (parseTree.getChild(0) instanceof yqlplusParser.MultiplicativeExpressionContext) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.getText(), new Object[0]);
            }
            case 74: {
                if (1 == parseTree.getChildCount()) {
                    return this.convertExpr(parseTree.getChild(0), scope);
                }
                if (2 == parseTree.getChildCount()) {
                    if ("-".equals(parseTree.getChild(0).getText())) {
                        return this.readUnOp(ExpressionOperator.NEGATE, parseTree, scope);
                    }
                    if ("!".equals(parseTree.getChild(0).getText())) {
                        return this.readUnOp(ExpressionOperator.NOT, parseTree, scope);
                    }
                    throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown unary operator " + parseTree.getText(), new Object[0]);
                }
                throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown child count " + parseTree.getChildCount() + " of " + parseTree.getText(), new Object[0]);
            }
            case 57: 
            case 81: {
                List<String> path = this.readName((yqlplusParser.Namespaced_nameContext)parseTree.getChild(0));
                Location loc = this.toLocation(scope, parseTree.getChild(0));
                String alias = path.get(0);
                OperatorNode<ExpressionOperator> result = null;
                int start = 0;
                if (scope.isCursor(alias)) {
                    if (path.size() > 1) {
                        result = OperatorNode.create(loc, ExpressionOperator.READ_FIELD, alias, path.get(1));
                        start = 2;
                    } else {
                        result = OperatorNode.create(loc, ExpressionOperator.READ_RECORD, alias);
                        start = 1;
                    }
                } else {
                    if (scope.isBound(alias)) {
                        return OperatorNode.create(loc, ExpressionOperator.READ_MODULE, scope.getBinding(alias).toPathWith(path.subList(1, path.size())));
                    }
                    if (scope.getCursors().size() == 1) {
                        alias = scope.getCursors().iterator().next();
                        result = OperatorNode.create(loc, ExpressionOperator.READ_FIELD, alias, path.get(0));
                        start = 1;
                    } else {
                        throw new ProgramCompileException(loc, "Unknown field or alias '%s'", alias);
                    }
                }
                for (int idx = start; idx < path.size(); ++idx) {
                    result = OperatorNode.create(loc, ExpressionOperator.PROPREF, result, path.get(idx));
                }
                return result;
            }
            case 89: {
                return OperatorNode.create(this.toLocation(scope, parseTree), ExpressionOperator.LITERAL, this.convertLiteral((yqlplusParser.Scalar_literalContext)parseTree));
            }
            case 98: {
                return this.readValues((yqlplusParser.Insert_valuesContext)parseTree, scope);
            }
            case 87: {
                return this.convertExpr(parseTree.getChild(0), scope);
            }
            case 92: {
                if (ProgramParser.getParseTreeIndex(parseTree.getChild(1)) == 91) {
                    return this.convertExpr(parseTree.getChild(1), scope);
                }
                List<yqlplusParser.Literal_elementContext> elements = ((yqlplusParser.Literal_listContext)parseTree).literal_element();
                ParseTree firldElement = elements.get(0).getChild(0);
                if (elements.size() == 1 && scope.getParser().isArrayParameter(firldElement)) {
                    return this.convertExpr(firldElement, scope);
                }
                ArrayList values = Lists.newArrayListWithExpectedSize((int)elements.size());
                for (yqlplusParser.Literal_elementContext child : elements) {
                    values.add(this.convertExpr(child.getChild(0), scope));
                }
                return OperatorNode.create(this.toLocation(scope, (ParseTree)elements.get(0)), ExpressionOperator.ARRAY, values);
            }
        }
        throw new ProgramCompileException(this.toLocation(scope, parseTree), "Unknown expression type: " + parseTree.getText(), new Object[0]);
    }

    public Object convertLiteral(yqlplusParser.Scalar_literalContext literal) {
        int parseTreeIndex = ProgramParser.getParseTreeIndex(literal.getChild(0));
        String text = literal.getChild(0).getText();
        switch (parseTreeIndex) {
            case 97: {
                return new Integer(text);
            }
            case 98: {
                return new Double(text);
            }
            case 99: {
                return StringUnescaper.unquote(text);
            }
            case 59: 
            case 60: {
                return new Boolean(text);
            }
            case 96: {
                return Long.parseLong(text.substring(0, text.length() - 1));
            }
        }
        throw new ProgramCompileException("Unknow literal type " + text);
    }

    private Object readConstantExpression(OperatorNode<ExpressionOperator> node) {
        switch (node.getOperator()) {
            case LITERAL: {
                return node.getArgument(0);
            }
            case MAP: {
                ImmutableMap.Builder map = ImmutableMap.builder();
                List names = (List)((Object)node.getArgument(0));
                List exprs = (List)((Object)node.getArgument(1));
                for (int i = 0; i < names.size(); ++i) {
                    map.put(names.get(i), this.readConstantExpression((OperatorNode)exprs.get(i)));
                }
                return map.build();
            }
            case ARRAY: {
                List exprs = (List)((Object)node.getArgument(0));
                ImmutableList.Builder lst = ImmutableList.builder();
                for (OperatorNode expr : exprs) {
                    lst.add(this.readConstantExpression(expr));
                }
                return lst.build();
            }
        }
        throw new ProgramCompileException(node.getLocation(), "Internal error: Unknown constant expression type: " + node.getOperator(), new Object[0]);
    }

    private OperatorNode<ExpressionOperator> readBinOp(ExpressionOperator op, ParseTree node, Scope scope) {
        assert (node.getChildCount() == 3);
        return OperatorNode.create(op, this.convertExpr(node.getChild(0), scope), this.convertExpr(node.getChild(2), scope));
    }

    private OperatorNode<ExpressionOperator> readBinOp(ExpressionOperator op, ParseTree operand1, ParseTree operand2, Scope scope) {
        return OperatorNode.create(op, this.convertExpr(operand1, scope), this.convertExpr(operand2, scope));
    }

    private OperatorNode<ExpressionOperator> readConjOp(ExpressionOperator op, List<yqlplusParser.EqualityExpressionContext> nodes, Scope scope) {
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)nodes.size());
        for (ParseTree parseTree : nodes) {
            arguments.add(this.convertExpr(parseTree, scope));
        }
        return OperatorNode.create(op, arguments);
    }

    private OperatorNode<ExpressionOperator> readConjOrOp(ExpressionOperator op, yqlplusParser.LogicalORExpressionContext node, Scope scope) {
        List<yqlplusParser.LogicalANDExpressionContext> andExpressionList = node.logicalANDExpression();
        ArrayList arguments = Lists.newArrayListWithExpectedSize((int)andExpressionList.size());
        for (yqlplusParser.LogicalANDExpressionContext child : andExpressionList) {
            List<yqlplusParser.EqualityExpressionContext> equalities = child.equalityExpression();
            if (equalities.size() == 1) {
                arguments.add(this.convertExpr((ParseTree)equalities.get(0), scope));
                continue;
            }
            ArrayList andArguments = Lists.newArrayListWithExpectedSize((int)equalities.size());
            for (yqlplusParser.EqualityExpressionContext subTreeChild : equalities) {
                andArguments.add(this.convertExpr((ParseTree)subTreeChild, scope));
            }
            arguments.add(OperatorNode.create(ExpressionOperator.AND, andArguments));
        }
        return OperatorNode.create(op, arguments);
    }

    private OperatorNode<ExpressionOperator> readUnOp(ExpressionOperator op, ParseTree node, Scope scope) {
        assert (node instanceof TerminalNode || node.getChildCount() == 1 || node instanceof yqlplusParser.UnaryExpressionContext);
        if (node instanceof TerminalNode) {
            return OperatorNode.create(op, this.convertExpr(node, scope));
        }
        if (node.getChildCount() == 1) {
            return OperatorNode.create(op, this.convertExpr(node.getChild(0), scope));
        }
        return OperatorNode.create(op, this.convertExpr(node.getChild(1), scope));
    }

    private OperatorNode<ExpressionOperator> readValues(yqlplusParser.Field_names_specContext nameDefs, yqlplusParser.Field_values_specContext values, Scope scope) {
        List<yqlplusParser.Field_defContext> fieldDefs = nameDefs.field_def();
        List<yqlplusParser.ExpressionContext> valueDefs = values.expression();
        assert (fieldDefs.size() == valueDefs.size());
        int numPairs = fieldDefs.size();
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)numPairs);
        ArrayList fieldValues = Lists.newArrayListWithExpectedSize((int)numPairs);
        for (int i = 0; i < numPairs; ++i) {
            fieldNames.add((String)((Object)this.convertExpr((ParseTree)fieldDefs.get(i).expression(), scope).getArgument(1)));
            fieldValues.add(this.convertExpr((ParseTree)valueDefs.get(i), scope));
        }
        return OperatorNode.create(ExpressionOperator.MAP, fieldNames, fieldValues);
    }

    private OperatorNode<ExpressionOperator> readValues(ParserRuleContext node, Scope scope) {
        ArrayList fieldValues;
        ArrayList fieldNames;
        if (node.getRuleIndex() == 51) {
            yqlplusParser.Field_defContext fieldDefContext = (yqlplusParser.Field_defContext)node;
            fieldNames = Lists.newArrayListWithExpectedSize((int)node.getChildCount());
            fieldValues = Lists.newArrayListWithExpectedSize((int)node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                fieldNames.add((String)((Object)this.convertExpr(node.getChild(i).getChild(0).getChild(0), scope).getArgument(1)));
                fieldValues.add(this.convertExpr(node.getChild(i).getChild(0).getChild(1), scope));
            }
        } else {
            assert (node.getChildCount() % 2 == 0);
            int numPairs = node.getChildCount() / 2;
            fieldNames = Lists.newArrayListWithExpectedSize((int)numPairs);
            fieldValues = Lists.newArrayListWithExpectedSize((int)numPairs);
            for (int i = 0; i < numPairs; ++i) {
                fieldNames.add((String)((Object)this.convertExpr(node.getChild(i).getChild(0), scope).getArgument(1)));
                fieldValues.add(this.convertExpr(node.getChild(numPairs + i), scope));
            }
        }
        return OperatorNode.create(ExpressionOperator.MAP, fieldNames, fieldValues);
    }

    private OperatorNode<SequenceOperator> readBatchValues(yqlplusParser.Field_names_specContext nameDefs, List<yqlplusParser.Field_values_group_specContext> valueGroups, Scope scope) {
        List<yqlplusParser.Field_defContext> nameContexts = nameDefs.field_def();
        ArrayList fieldNames = Lists.newArrayList();
        for (yqlplusParser.Field_defContext nameContext : nameContexts) {
            fieldNames.add((String)((Object)this.convertExpr(nameContext.getChild(0), scope).getArgument(1)));
        }
        ArrayList records = Lists.newArrayList();
        for (yqlplusParser.Field_values_group_specContext valueGorup : valueGroups) {
            List<yqlplusParser.ExpressionContext> expressionList = valueGorup.expression();
            ArrayList fieldValues = Lists.newArrayListWithExpectedSize((int)expressionList.size());
            for (yqlplusParser.ExpressionContext expressionContext : expressionList) {
                fieldValues.add(this.convertExpr((ParseTree)expressionContext, scope));
            }
            records.add(OperatorNode.create(ExpressionOperator.MAP, fieldNames, fieldValues));
        }
        return OperatorNode.create(SequenceOperator.EVALUATE, OperatorNode.create(ExpressionOperator.ARRAY, records));
    }

    private List<OperatorNode<ExpressionOperator>> getReadFieldExpressions(OperatorNode<ExpressionOperator> in) {
        ArrayList readFieldList = Lists.newArrayList();
        switch (in.getOperator()) {
            case READ_FIELD: {
                readFieldList.add(in);
                break;
            }
            case CALL: {
                List callArgs = (List)((Object)in.getArgument(1));
                for (OperatorNode callArg : callArgs) {
                    if (callArg.getOperator() != ExpressionOperator.READ_FIELD) continue;
                    readFieldList.add(callArg);
                }
                break;
            }
        }
        return readFieldList;
    }

    static class Scope {
        final Scope root;
        final Scope parent;
        Set<String> cursors = ImmutableSet.of();
        Set<String> variables = ImmutableSet.of();
        Set<String> views = Sets.newHashSet();
        Map<String, Binding> bindings = Maps.newHashMap();
        final yqlplusParser parser;
        final String programName;

        Scope() {
            this.parser = null;
            this.programName = null;
            this.root = this;
            this.parent = null;
        }

        Scope(yqlplusParser parser, String programName) {
            this.parser = parser;
            this.programName = programName;
            this.root = this;
            this.parent = null;
        }

        Scope(Scope root, Scope parent) {
            this.root = root;
            this.parent = parent;
            this.parser = parent.parser;
            this.programName = parent.programName;
        }

        public yqlplusParser getParser() {
            return this.parser;
        }

        public String getProgramName() {
            return this.programName;
        }

        public Set<String> getCursors() {
            return this.cursors;
        }

        boolean isBound(String name) {
            return this.root.bindings.containsKey(name);
        }

        public Binding getBinding(String name) {
            return this.root.bindings.get(name);
        }

        public List<String> resolvePath(List<String> path) {
            if (path.size() < 1 || !this.isBound(path.get(0))) {
                return path;
            }
            return this.getBinding(path.get(0)).toPathWith(path.subList(1, path.size()));
        }

        boolean isCursor(String name) {
            return this.cursors.contains(name) || this.parent != null && this.parent.isCursor(name);
        }

        boolean isVariable(String name) {
            return this.variables.contains(name) || this.parent != null && this.parent.isVariable(name);
        }

        public void bindModule(Location loc, List<String> binding, String symbolName) {
            if (this.isBound(symbolName)) {
                throw new ProgramCompileException(loc, "Name '%s' is already used.", symbolName);
            }
            this.root.bindings.put(symbolName, new Binding(binding));
        }

        public void bindModuleSymbol(Location loc, List<String> moduleName, String exportName, String symbolName) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(moduleName);
            builder.add((Object)exportName);
            this.bindModule(loc, (List<String>)builder.build(), symbolName);
        }

        public void defineDataSource(Location loc, String name) {
            if (this.isCursor(name)) {
                throw new ProgramCompileException(loc, "Alias '%s' is already used.", name);
            }
            if (this.cursors.isEmpty()) {
                this.cursors = Sets.newHashSet();
            }
            this.cursors.add(name);
        }

        public void defineVariable(Location loc, String name) {
            if (this.isVariable(name)) {
                throw new ProgramCompileException(loc, "Variable/argument '%s' is already used.", name);
            }
            if (this.variables.isEmpty()) {
                this.variables = Sets.newHashSet();
            }
            this.variables.add(name);
        }

        public void defineView(Location loc, String text) {
            if (this != this.root) {
                throw new IllegalStateException("Views MUST be defined in 'root' scope only");
            }
            if (this.views.contains(text)) {
                throw new ProgramCompileException(loc, "View '%s' already defined", text);
            }
            this.views.add(text);
        }

        Scope child() {
            return new Scope(this.root, this);
        }

        Scope getRoot() {
            return this.root;
        }
    }

    static class Binding {
        private final List<String> binding;

        Binding(String moduleName, String exportName) {
            this.binding = ImmutableList.of((Object)moduleName, (Object)exportName);
        }

        Binding(String moduleName) {
            this.binding = ImmutableList.of((Object)moduleName);
        }

        Binding(List<String> binding) {
            this.binding = binding;
        }

        public List<String> toPath() {
            return this.binding;
        }

        public List<String> toPathWith(List<String> rest) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.toPath(), rest));
        }
    }
}

