/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.base.Preconditions;
import com.yahoo.search.yql.Operator;
import com.yahoo.search.yql.OperatorTypeChecker;
import java.util.List;

class JavaListTypeChecker
extends OperatorTypeChecker {
    private final Class<?> elementType;

    public JavaListTypeChecker(Operator parent, int idx, Class<?> elementType) {
        super(parent, idx);
        this.elementType = elementType;
    }

    @Override
    public void check(Object argument) {
        Preconditions.checkNotNull((Object)argument, (String)"Argument %s of %s must not be null", (Object[])new Object[]{this.idx, this.parent});
        Preconditions.checkArgument((boolean)(argument instanceof List), (String)"Argument %s of %s must be a List<%s>", (Object[])new Object[]{this.idx, this.parent, this.elementType.getName(), argument.getClass().getName()});
        List lst = (List)argument;
        for (Object elt : lst) {
            Preconditions.checkNotNull(elt, (String)"Argument %s of %s List elements may not be null", (Object[])new Object[]{this.idx, this.parent});
            Preconditions.checkArgument((boolean)this.elementType.isInstance(elt), (String)"Argument %s of %s List elements must be %s (is %s)", (Object[])new Object[]{this.idx, this.parent, this.elementType.getName(), elt.getClass().getName()});
        }
    }
}

