/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.yql;

import com.google.common.annotations.Beta;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@After(value={"ExternalYql"})
@Beta
public class FieldFiller
extends Searcher {
    private final Set<String> intersectionOfAttributes;
    private final SummaryIntersections summaryDb = new SummaryIntersections();
    public static final CompoundName FIELD_FILLER_DISABLE = new CompoundName("FieldFiller.disable");

    public FieldFiller(DocumentdbInfoConfig config) {
        this.intersectionOfAttributes = new HashSet<String>();
        boolean first = true;
        for (DocumentdbInfoConfig.Documentdb db : config.documentdb()) {
            for (DocumentdbInfoConfig.Documentdb.Summaryclass summary : db.summaryclass()) {
                if ("attributeprefetch".equals(summary.name())) {
                    HashSet<String> attributes = new HashSet<String>(summary.fields().size());
                    for (DocumentdbInfoConfig.Documentdb.Summaryclass.Fields f : summary.fields()) {
                        attributes.add(f.name());
                    }
                    if (first) {
                        first = false;
                        this.intersectionOfAttributes.addAll(attributes);
                    } else {
                        this.intersectionOfAttributes.retainAll(attributes);
                    }
                }
                this.summaryDb.add(db.name(), summary);
            }
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        return execution.search(query);
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        execution.fill(result, summaryClass);
        Set<String> summaryFields = result.getQuery().getPresentation().getSummaryFields();
        if (summaryFields.isEmpty() || summaryClass == null || result.getQuery().properties().getBoolean(FIELD_FILLER_DISABLE)) {
            return;
        }
        if (this.intersectionOfAttributes.containsAll(summaryFields)) {
            if (!"attributeprefetch".equals(summaryClass)) {
                execution.fill(result, "attributeprefetch");
            }
        } else if (!this.summaryDb.hasAll(summaryFields, summaryClass, result.getQuery().getModel().getRestrict())) {
            execution.fill(result, null);
        }
    }

    private static class SummaryIntersections {
        private final Map<String, Map<String, Set<String>>> db = new HashMap<String, Map<String, Set<String>>>();

        private SummaryIntersections() {
        }

        void add(String dbName, DocumentdbInfoConfig.Documentdb.Summaryclass summary) {
            Map<String, Set<String>> docType = this.getOrCreateDocType(dbName);
            HashSet<String> fields = new HashSet<String>(summary.fields().size());
            for (DocumentdbInfoConfig.Documentdb.Summaryclass.Fields f : summary.fields()) {
                fields.add(f.name());
            }
            docType.put(summary.name(), fields);
        }

        @NonNull
        private Map<String, Set<String>> getOrCreateDocType(String dbName) {
            Map<String, Set<String>> docType = this.db.get(dbName);
            if (docType == null) {
                docType = new HashMap<String, Set<String>>();
                this.db.put(dbName, docType);
            }
            return docType;
        }

        boolean hasAll(Set<String> requested, String summaryName, Set<String> restrict) {
            HashSet<String> intersection = null;
            Set<String> explicitRestriction = restrict.isEmpty() ? this.db.keySet() : restrict;
            for (String docType : explicitRestriction) {
                Map<String, Set<String>> summaries = this.db.get(docType);
                if (summaries == null) continue;
                Set<String> summary = summaries.get(summaryName);
                if (summary == null) {
                    intersection = null;
                    break;
                }
                if (intersection == null) {
                    intersection = new HashSet<String>(summary.size());
                    intersection.addAll(summary);
                    continue;
                }
                intersection.retainAll(summary);
            }
            return intersection != null && intersection.containsAll(requested);
        }
    }
}

