/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain.model.federation;

import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.search.federation.http.HTTPProviderSearcher;
import com.yahoo.search.federation.vespa.VespaSearcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class HttpProviderSpec {
    public final ConnectionParameters connectionParameters;
    public final Integer cacheSizeMB;
    public final String path;
    public final List<Node> nodes;
    public final String ycaApplicationId;
    public final Integer ycaCertificateTtl;
    public final Integer ycaRetryWait;
    public final Node ycaProxy;
    public final double cacheWeight;

    public static BundleInstantiationSpecification toBundleInstantiationSpecification(Type type) {
        return BundleInstantiationSpecification.getInternalSearcherSpecificationFromStrings((String)type.className, null);
    }

    public static boolean includesType(String typeString) {
        for (Type type : Type.values()) {
            if (!type.name().equals(typeString)) continue;
            return true;
        }
        return false;
    }

    public HttpProviderSpec(Double cacheWeight, String path, List<Node> nodes, String ycaApplicationId, Integer ycaCertificateTtl, Integer ycaRetryWait, Node ycaProxy, Integer cacheSizeMB, ConnectionParameters connectionParameters) {
        double defaultCacheWeight = 1.0;
        this.cacheWeight = cacheWeight != null ? cacheWeight : 1.0;
        this.path = path;
        this.nodes = this.unmodifiable(nodes);
        this.ycaApplicationId = ycaApplicationId;
        this.ycaProxy = ycaProxy;
        this.ycaCertificateTtl = ycaCertificateTtl;
        this.ycaRetryWait = ycaRetryWait;
        this.cacheSizeMB = cacheSizeMB;
        this.connectionParameters = connectionParameters;
    }

    private List<Node> unmodifiable(List<Node> nodes) {
        return nodes == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Node>(nodes));
    }

    public static class Node {
        public final String host;
        public final int port;

        public Node(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String toString() {
            return "Node{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }

    public static class ConnectionParameters {
        public final Double readTimeout;
        public final Double connectionTimeout;
        public final Double connectionPoolTimeout;
        public final Integer retries;

        public ConnectionParameters(Double readTimeout, Double connectionTimeout, Double connectionPoolTimeout, Integer retries) {
            this.readTimeout = readTimeout;
            this.connectionTimeout = connectionTimeout;
            this.connectionPoolTimeout = connectionPoolTimeout;
            this.retries = retries;
        }
    }

    public static enum Type {
        vespa(VespaSearcher.class);

        final String className;

        private Type(Class<? extends HTTPProviderSearcher> searcherClass) {
            this.className = searcherClass.getName();
        }
    }
}

