/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.rendering;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.prelude.templates.PageTemplateSet;
import com.yahoo.prelude.templates.SearchRendererAdaptor;
import com.yahoo.prelude.templates.TiledTemplateSet;
import com.yahoo.prelude.templates.UserTemplate;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.search.Result;
import com.yahoo.search.rendering.DefaultRenderer;
import com.yahoo.search.rendering.JsonRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;

public final class RendererRegistry
extends ComponentRegistry<Renderer<Result>> {
    public static final ComponentId xmlRendererId = ComponentId.fromString((String)"DefaultRenderer");
    public static final ComponentId jsonRendererId;
    public static final ComponentId defaultRendererId;
    private final ComponentId tiledRendererId;
    private final ComponentId pageRendererId;

    public RendererRegistry() {
        this(Collections.emptyList());
    }

    public RendererRegistry(Executor executor) {
        this(Collections.emptyList(), executor);
    }

    public RendererRegistry(Collection<Renderer> renderers) {
        this(renderers, null);
    }

    public RendererRegistry(Collection<Renderer> renderers, Executor executor) {
        JsonRenderer jsonRenderer = new JsonRenderer(executor);
        jsonRenderer.initId(jsonRendererId);
        this.register(jsonRenderer.getId(), (Object)jsonRenderer);
        DefaultRenderer xmlRenderer = new DefaultRenderer(executor);
        xmlRenderer.initId(xmlRendererId);
        this.register(xmlRenderer.getId(), (Object)xmlRenderer);
        for (Renderer renderer : renderers) {
            this.register(renderer.getId(), renderer);
        }
        this.tiledRendererId = this.addTemplateSet(new TiledTemplateSet());
        this.pageRendererId = this.addTemplateSet(new PageTemplateSet());
        this.freeze();
    }

    public void deconstruct() {
        this.getRenderer(jsonRendererId.toSpecification()).deconstruct();
        this.getRenderer(xmlRendererId.toSpecification()).deconstruct();
        this.getRenderer(this.tiledRendererId.toSpecification()).deconstruct();
        this.getRenderer(this.pageRendererId.toSpecification()).deconstruct();
    }

    private ComponentId addTemplateSet(UserTemplate<?> templateSet) {
        SearchRendererAdaptor renderer = new SearchRendererAdaptor(templateSet);
        ComponentId rendererId = new ComponentId(templateSet.getName());
        renderer.initId(rendererId);
        this.register(rendererId, (Object)renderer);
        return rendererId;
    }

    public Renderer<Result> getDefaultRenderer() {
        return (Renderer)this.getComponent(jsonRendererId);
    }

    public Renderer<Result> getRenderer(ComponentSpecification format) {
        if (format == null || format.stringValue().equals("default")) {
            return this.getDefaultRenderer();
        }
        if (format.stringValue().equals("json")) {
            return (Renderer)this.getComponent(jsonRendererId);
        }
        if (format.stringValue().equals("xml")) {
            return (Renderer)this.getComponent(xmlRendererId);
        }
        Renderer renderer = (Renderer)this.getComponent(format);
        if (renderer == null) {
            throw new IllegalArgumentException("No renderer with id or alias '" + format + "'. Available renderers are: [" + this.rendererNames() + "].");
        }
        return renderer;
    }

    private String rendererNames() {
        StringBuilder r = new StringBuilder();
        for (Renderer c : this.allComponents()) {
            if (r.length() > 0) {
                r.append(", ");
            }
            r.append(c.getId().stringValue());
        }
        return r.toString();
    }

    static {
        defaultRendererId = jsonRendererId = ComponentId.fromString((String)"JsonRenderer");
    }
}

