/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.query.properties.DefaultProperties;
import com.yahoo.search.query.ranking.MatchPhase;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.chain.After;
import com.yahoo.yolean.chain.Before;

@Before(value={"queryCanonicalization"})
@After(value={"SelectParameterParsing"})
public class SortingDegrader
extends Searcher {
    public static final CompoundName DEGRADING = new CompoundName("sorting.degrading");
    public static final CompoundName PAGINATION = new CompoundName("to_be_removed_pagination");

    @Override
    public Result search(Query query, Execution execution) {
        if (this.shouldBeDegraded(query, execution.context().getIndexFacts().newSession(query))) {
            this.setDegradation(query);
        }
        return execution.search(query);
    }

    private boolean shouldBeDegraded(Query query, IndexFacts.Session indexFacts) {
        if (query.getRanking().getSorting() == null) {
            return false;
        }
        if (query.getRanking().getSorting().fieldOrders().isEmpty()) {
            return false;
        }
        if (!GroupingRequest.getRequests(query).isEmpty()) {
            return false;
        }
        if (!query.properties().getBoolean(DEGRADING, true)) {
            return false;
        }
        Index index = indexFacts.getIndex(query.getRanking().getSorting().fieldOrders().get(0).getFieldName());
        if (index == null) {
            return false;
        }
        if (!index.isFastSearch()) {
            return false;
        }
        return index.isNumerical();
    }

    private void setDegradation(Query query) {
        query.trace("Using sorting degrading for performance - totalHits will be wrong. Turn off with sorting.degrading=false.", 2);
        Sorting.FieldOrder primarySort = query.getRanking().getSorting().fieldOrders().get(0);
        MatchPhase matchPhase = query.getRanking().getMatchPhase();
        matchPhase.setAttribute(primarySort.getFieldName());
        matchPhase.setAscending(primarySort.getSortOrder() == Sorting.Order.ASCENDING);
        if (matchPhase.getMaxHits() == null) {
            matchPhase.setMaxHits(this.decideDefaultMaxHits(query));
        }
    }

    private long decideDefaultMaxHits(Query query) {
        int maxOffset;
        int maxHits;
        if (query.properties().getBoolean(PAGINATION, true)) {
            maxHits = query.properties().getInteger(DefaultProperties.MAX_HITS);
            maxOffset = query.properties().getInteger(DefaultProperties.MAX_OFFSET);
        } else {
            maxHits = query.getHits();
            maxOffset = query.getOffset();
        }
        return maxHits + maxOffset;
    }
}

