/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine;

import com.yahoo.search.Result;
import com.yahoo.search.pagetemplates.PageTemplate;
import com.yahoo.search.pagetemplates.engine.RelevanceComparator;
import com.yahoo.search.pagetemplates.engine.Resolution;
import com.yahoo.search.pagetemplates.engine.SourceOrderComparator;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.Placeholder;
import com.yahoo.search.pagetemplates.model.Renderer;
import com.yahoo.search.pagetemplates.model.Section;
import com.yahoo.search.pagetemplates.model.Source;
import com.yahoo.search.pagetemplates.result.SectionHitGroup;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.ChainableComparator;
import com.yahoo.search.result.DefaultErrorHit;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.FieldComparator;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.HitGroup;
import com.yahoo.search.result.HitSortOrderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Organizer {
    public void organize(Choice templateChoice, Resolution resolution, Result result) {
        PageTemplate template = (PageTemplate)templateChoice.get(resolution.getResolution(templateChoice)).get(0);
        SectionHitGroup sectionGroup = this.toGroup(template.getSection(), resolution, result);
        ErrorHit errors = result.hits().getErrorHit();
        sectionGroup.setQuery(result.hits().getQuery());
        if (errors != null && errors instanceof DefaultErrorHit) {
            sectionGroup.add((DefaultErrorHit)errors);
        }
        Iterator<Map.Entry<String, Object>> it = result.hits().fieldIterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> field = it.next();
            sectionGroup.setField(field.getKey(), field.getValue());
        }
        result.setHits(sectionGroup);
    }

    private SectionHitGroup toGroup(Section section, Resolution resolution, Result result) {
        SectionHitGroup sectionGroup = new SectionHitGroup("section:" + section.getId());
        this.setField("id", section.getId(), sectionGroup);
        sectionGroup.setLeaf(section.elements(Section.class).size() == 0);
        this.setField("layout", section.getLayout().getName(), sectionGroup);
        this.setField("region", section.getRegion(), sectionGroup);
        ArrayList<String> sourceList = new ArrayList<String>();
        this.renderElements(resolution, result, sectionGroup, sourceList, section.elements());
        if (section.getMax() >= 0) {
            sectionGroup.trim(0, section.getMax());
        }
        if (sectionGroup.size() > 1) {
            this.assignOrderer(section, resolution, sourceList, sectionGroup);
        }
        return sectionGroup;
    }

    private void renderElements(Resolution resolution, Result result, SectionHitGroup sectionGroup, List<String> sourceList, List<PageElement> elements) {
        for (PageElement element : elements) {
            if (element instanceof Section) {
                sectionGroup.add(this.toGroup((Section)element, resolution, result));
                continue;
            }
            if (element instanceof Source) {
                this.addSource(resolution, (Source)element, sectionGroup, result, sourceList);
                continue;
            }
            if (element instanceof Renderer) {
                sectionGroup.renderers().add((Renderer)element);
                continue;
            }
            if (element instanceof Choice) {
                Choice choice = (Choice)element;
                if (choice.isEmpty()) continue;
                int chosen = resolution.getResolution(choice);
                this.renderElements(resolution, result, sectionGroup, sourceList, choice.alternatives().get(chosen));
                continue;
            }
            if (!(element instanceof Placeholder)) continue;
            Placeholder placeholder = (Placeholder)element;
            List<PageElement> mappedElements = resolution.getResolution(placeholder.getValueContainer()).get(placeholder.getId());
            this.renderElements(resolution, result, sectionGroup, sourceList, mappedElements);
        }
    }

    private void setField(String fieldName, Object value, Hit to) {
        if (value == null) {
            return;
        }
        to.setField(fieldName, value);
    }

    private void addSource(Resolution resolution, Source source, SectionHitGroup sectionGroup, Result result, List<String> sourceList) {
        this.renderElements(resolution, result, sectionGroup, sourceList, source.renderers());
        if (source.getUrl() == null) {
            this.addHitsFromSource(source, sectionGroup, result, sourceList);
        } else {
            sectionGroup.sources().add(source);
        }
    }

    private void addHitsFromSource(Source source, SectionHitGroup sectionGroup, Result result, List<String> sourceList) {
        if (source == Source.any) {
            for (Hit hit : result.hits()) {
                String sourceName;
                String groupId;
                if (!(hit instanceof HitGroup) || !(groupId = hit.getId().stringValue()).startsWith("source:") || sourceList.contains(sourceName = groupId.substring(7))) continue;
                sectionGroup.addAll(((HitGroup)hit).asList());
                sourceList.add(sourceName);
            }
        } else {
            HitGroup sourceGroup = (HitGroup)result.hits().get("source:" + source.getName());
            if (sourceGroup != null) {
                sectionGroup.addAll(sourceGroup.asList());
            }
            sourceList.add(source.getName());
        }
    }

    private void assignOrderer(Section section, Resolution resolution, List<String> sourceList, HitGroup group) {
        ChainableComparator comparator;
        if (section.getOrder() == null) {
            group.setOrderer(new HitSortOrderer(new RelevanceComparator(new SourceOrderComparator(sourceList))));
            return;
        }
        Sorting sorting = section.getOrder();
        int rankIndex = -1;
        int sourceIndex = -1;
        for (int i = 0; i < sorting.fieldOrders().size(); ++i) {
            Sorting.FieldOrder order = sorting.fieldOrders().get(i);
            if ("[relevance]".equals(order.getFieldName()) || "[rank]".equals(order.getFieldName())) {
                rankIndex = i;
                continue;
            }
            if (!order.getFieldName().equals("[source]")) continue;
            sourceIndex = i;
        }
        Sorting beforeSource = null;
        Sorting afterSource = null;
        if (sourceIndex >= 0) {
            if (sourceIndex > 0) {
                beforeSource = new Sorting(new ArrayList<Sorting.FieldOrder>(sorting.fieldOrders().subList(0, sourceIndex)));
            }
            if (sorting.fieldOrders().size() > sourceIndex + 1) {
                afterSource = new Sorting(new ArrayList<Sorting.FieldOrder>(sorting.fieldOrders().subList(sourceIndex + 1, sorting.fieldOrders().size() + 1)));
            }
            comparator = new SourceOrderComparator(sourceList, FieldComparator.create(afterSource));
            if (beforeSource != null) {
                comparator = new FieldComparator(beforeSource, comparator);
            }
        } else {
            comparator = rankIndex >= 0 ? new FieldComparator(sorting, new SourceOrderComparator(sourceList)) : new FieldComparator(sorting, new RelevanceComparator(new SourceOrderComparator(sourceList)));
        }
        group.setOrderer(new HitSortOrderer(comparator));
    }
}

