/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.collections.LazyMap;
import com.yahoo.collections.LazySet;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingNode;
import com.yahoo.search.grouping.request.parser.GroupingParser;
import com.yahoo.search.grouping.request.parser.GroupingParserInput;
import com.yahoo.search.grouping.request.parser.ParseException;
import com.yahoo.search.grouping.request.parser.TokenMgrError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GroupingOperation
extends GroupingNode {
    private final List<GroupingExpression> orderBy = new ArrayList<GroupingExpression>();
    private final List<GroupingExpression> outputs = new ArrayList<GroupingExpression>();
    private final List<GroupingOperation> children = new ArrayList<GroupingOperation>();
    private final Map<String, GroupingExpression> alias = LazyMap.newHashMap();
    private final Set<String> hints = LazySet.newHashSet();
    private GroupingExpression groupBy = null;
    private GroupingOperation parent = null;
    private String where = null;
    private boolean forceSinglePass = false;
    private double accuracy = 0.95;
    private int precision = 0;
    private int level = -1;
    private int max = -1;

    protected GroupingOperation(String image) {
        super(image);
    }

    public GroupingOperation putAlias(String id, GroupingExpression exp) {
        this.alias.put(id, exp);
        return this;
    }

    public GroupingExpression getAlias(String id) {
        if (this.alias.containsKey(id)) {
            return this.alias.get(id);
        }
        if (this.parent != null) {
            return this.parent.getAlias(id);
        }
        return null;
    }

    public GroupingOperation addHint(String hint) {
        this.hints.add(hint);
        return this;
    }

    public boolean containsHint(String hint) {
        return this.hints.contains(hint);
    }

    public Set<String> getHints() {
        return Collections.unmodifiableSet(this.hints);
    }

    public GroupingOperation addChild(GroupingOperation op) {
        op.parent = this;
        this.children.add(op);
        return this;
    }

    public GroupingOperation addChildren(List<GroupingOperation> lst) {
        for (GroupingOperation op : lst) {
            this.addChild(op);
        }
        return this;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public GroupingOperation getChild(int i) {
        return this.children.get(i);
    }

    public List<GroupingOperation> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public GroupingOperation setGroupBy(GroupingExpression exp) {
        this.groupBy = exp;
        return this;
    }

    public GroupingExpression getGroupBy() {
        return this.groupBy;
    }

    public int getLevel() {
        return this.level;
    }

    public void resolveLevel(int level) {
        if (this.groupBy != null) {
            if (level == 0) {
                throw new IllegalArgumentException("Operation '" + this + "' can not group " + GroupingOperation.getLevelDesc(level) + ".");
            }
            this.groupBy.resolveLevel(level - 1);
            ++level;
        }
        if (this.hasMax() && level == 0) {
            throw new IllegalArgumentException("Operation '" + this + "' can not apply max to " + GroupingOperation.getLevelDesc(level) + ".");
        }
        this.level = level;
        for (GroupingExpression exp : this.outputs) {
            exp.resolveLevel(level);
        }
        if (!this.orderBy.isEmpty()) {
            if (level == 0) {
                throw new IllegalArgumentException("Operation '" + this + "' can not order " + GroupingOperation.getLevelDesc(level) + ".");
            }
            for (GroupingExpression exp : this.orderBy) {
                exp.resolveLevel(level - 1);
            }
        }
        for (GroupingOperation child : this.children) {
            child.resolveLevel(level);
        }
    }

    public GroupingOperation setForceSinglePass(boolean forceSinglePass) {
        this.forceSinglePass = forceSinglePass;
        return this;
    }

    public boolean getForceSinglePass() {
        return this.forceSinglePass;
    }

    public GroupingOperation setMax(int max) {
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public boolean hasMax() {
        return this.max >= 0;
    }

    public GroupingOperation setAccuracy(double accuracy) {
        if (accuracy > 1.0 || accuracy < 0.0) {
            throw new IllegalArgumentException("Illegal accuracy '" + accuracy + "'. Must be between 0 and 1.");
        }
        this.accuracy = accuracy;
        return this;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public GroupingOperation addOrderBy(GroupingExpression exp) {
        this.orderBy.add(exp);
        return this;
    }

    public GroupingOperation addOrderBy(List<GroupingExpression> lst) {
        for (GroupingExpression exp : lst) {
            this.addOrderBy(exp);
        }
        return this;
    }

    public int getNumOrderBy() {
        return this.orderBy.size();
    }

    public GroupingExpression getOrderBy(int i) {
        return this.orderBy.get(i);
    }

    public List<GroupingExpression> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public GroupingOperation addOutput(GroupingExpression exp) {
        this.outputs.add(exp);
        return this;
    }

    public GroupingOperation addOutputs(List<GroupingExpression> lst) {
        for (GroupingExpression exp : lst) {
            this.addOutput(exp);
        }
        return this;
    }

    public int getNumOutputs() {
        return this.outputs.size();
    }

    public GroupingExpression getOutput(int i) {
        return this.outputs.get(i);
    }

    public List<GroupingExpression> getOutputs() {
        return Collections.unmodifiableList(this.outputs);
    }

    public GroupingOperation setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public int getPrecision() {
        return this.precision;
    }

    public GroupingOperation setWhere(String str) {
        this.where = str;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public void visitExpressions(ExpressionVisitor visitor) {
        for (GroupingExpression exp : this.alias.values()) {
            exp.visit(visitor);
        }
        for (GroupingExpression exp : this.outputs) {
            exp.visit(visitor);
        }
        for (GroupingExpression exp : this.orderBy) {
            exp.visit(visitor);
        }
        if (this.groupBy != null) {
            this.groupBy.visit(visitor);
        }
        for (GroupingOperation op : this.children) {
            op.visitExpressions(visitor);
        }
    }

    @Override
    public GroupingOperation setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(super.toString()).append("(");
        if (this.groupBy != null) {
            ret.append("group(").append(this.groupBy).append(") ");
        }
        for (String hint : this.hints) {
            ret.append("hint(").append(hint).append(") ");
        }
        if (this.hasMax()) {
            ret.append("max(").append(this.max).append(") ");
        }
        if (!this.orderBy.isEmpty()) {
            ret.append("order(");
            ret.append(GroupingExpression.asString(this.orderBy));
            ret.append(") ");
        }
        if (!this.outputs.isEmpty()) {
            ret.append("output(");
            int len = this.outputs.size();
            for (int i = 0; i < len; ++i) {
                GroupingExpression exp = this.outputs.get(i);
                ret.append(exp);
                String label = exp.getLabel();
                if (label != null) {
                    ret.append(" as(").append(label).append(")");
                }
                if (i >= len - 1) continue;
                ret.append(", ");
            }
            ret.append(") ");
        }
        if (this.precision != 0) {
            ret.append("precision(").append(this.precision).append(") ");
        }
        if (this.where != null) {
            ret.append("where(").append(this.where).append(") ");
        }
        for (GroupingOperation child : this.children) {
            ret.append(child).append(" ");
        }
        int len = ret.length();
        if (ret.charAt(len - 1) == ' ') {
            ret.setLength(len - 1);
        }
        ret.append(")");
        String label = this.getLabel();
        if (label != null) {
            ret.append(" as(").append(label).append(")");
        }
        return ret.toString();
    }

    public static String getLevelDesc(int level) {
        if (level <= 0) {
            return "single hit";
        }
        if (level == 1) {
            return "single group";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 1; i < level; ++i) {
            ret.append("list of ");
        }
        ret.append("groups");
        return ret.toString();
    }

    public static GroupingOperation fromString(String str) {
        List<GroupingOperation> lst = GroupingOperation.fromStringAsList(str);
        if (lst.size() != 1) {
            throw new IllegalArgumentException("Expected 1 operation, got " + lst.size() + ".");
        }
        return lst.get(0);
    }

    public static List<GroupingOperation> fromStringAsList(String str) {
        if (str == null || str.trim().length() == 0) {
            return Collections.emptyList();
        }
        GroupingParserInput input = new GroupingParserInput(str);
        try {
            return new GroupingParser(input).requestList();
        }
        catch (ParseException | TokenMgrError e) {
            throw new IllegalArgumentException(input.formatException(e.getMessage()), e);
        }
    }
}

