/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.javacc.UnicodeUtilities;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingNode;
import java.util.List;

public abstract class GroupingExpression
extends GroupingNode {
    private Integer level = null;

    protected GroupingExpression(String image) {
        super(image);
    }

    public void resolveLevel(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Expression '" + this + "' recurses through a single hit.");
        }
        this.level = level;
    }

    public int getLevel() {
        if (this.level == null) {
            throw new IllegalStateException("Level for expression '" + this + "' has not been resolved.");
        }
        return this.level;
    }

    public void visit(ExpressionVisitor visitor) {
        visitor.visitExpression(this);
    }

    public static String asString(List<GroupingExpression> lst) {
        StringBuilder ret = new StringBuilder();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            ret.append(lst.get(i));
            if (i >= len - 1) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    public static String asImage(Object obj) {
        if (!(obj instanceof String)) {
            return obj.toString();
        }
        return UnicodeUtilities.quote((String)((String)obj), (char)'\"');
    }

    @Override
    public GroupingExpression setLabel(String label) {
        super.setLabel(label);
        return this;
    }
}

