/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.ConstantValue;
import com.yahoo.search.grouping.request.ConstantValueComparator;
import com.yahoo.search.grouping.request.GroupingExpression;

public class BucketValue
extends GroupingExpression
implements Comparable<BucketValue> {
    private final ConstantValue<?> from;
    private final ConstantValue<?> to;
    private final ConstantValueComparator comparator = new ConstantValueComparator();

    protected BucketValue(ConstantValue<?> inclusiveFrom, ConstantValue<?> exclusiveTo) {
        super("bucket[" + BucketValue.asImage(inclusiveFrom) + ", " + BucketValue.asImage(exclusiveTo) + ">");
        if (this.comparator.compare(exclusiveTo, inclusiveFrom) < 0) {
            throw new IllegalArgumentException("Bucket to-value can not be less than from-value.");
        }
        this.from = inclusiveFrom;
        this.to = exclusiveTo;
    }

    public ConstantValue<?> getFrom() {
        return this.from;
    }

    public ConstantValue<?> getTo() {
        return this.to;
    }

    @Override
    public int compareTo(BucketValue rhs) {
        if (this.comparator.compare(this.to, rhs.from) <= 0) {
            return -1;
        }
        if (this.comparator.compare(this.from, rhs.to) >= 0) {
            return 1;
        }
        return 0;
    }
}

