/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.GroupingOperation;

public abstract class AggregatorNode
extends GroupingExpression {
    private final GroupingExpression exp;

    protected AggregatorNode(String image) {
        super(image + "()");
        this.exp = null;
    }

    protected AggregatorNode(String image, GroupingExpression exp) {
        super(image + "(" + exp.toString() + ")");
        this.exp = exp;
    }

    public GroupingExpression getExpression() {
        return this.exp;
    }

    @Override
    public void resolveLevel(int level) {
        super.resolveLevel(level);
        if (level < 1) {
            throw new IllegalArgumentException("Expression '" + this + "' not applicable for " + GroupingOperation.getLevelDesc(level) + ".");
        }
        if (this.exp != null) {
            this.exp.resolveLevel(level - 1);
        }
    }

    @Override
    public void visit(ExpressionVisitor visitor) {
        super.visit(visitor);
        if (this.exp != null) {
            this.exp.visit(visitor);
        }
    }
}

