/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.net.URI;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.result.Hit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public class GroupingRequest {
    private static final CompoundName PROP_REQUEST = new CompoundName(GroupingRequest.class.getName() + ".Request");
    private final List<Continuation> continuations = new ArrayList<Continuation>();
    private final int requestId;
    private GroupingOperation root;
    private TimeZone timeZone;
    private URI resultId;

    private GroupingRequest(int requestId) {
        this.requestId = requestId;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public GroupingOperation getRootOperation() {
        return this.root;
    }

    public GroupingRequest setRootOperation(GroupingOperation root) {
        this.root = root;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public GroupingRequest setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RootGroup getResultGroup(Result result) {
        Hit root = result.hits().get(this.resultId, -1);
        if (!(root instanceof RootGroup)) {
            return null;
        }
        return (RootGroup)root;
    }

    public GroupingRequest setResultGroup(RootGroup group) {
        this.resultId = group.getId();
        return this;
    }

    public List<Continuation> continuations() {
        return this.continuations;
    }

    public static GroupingRequest newInstance(Query query) {
        List<GroupingRequest> lst = GroupingRequest.getRequests(query);
        if (lst.isEmpty()) {
            lst = new LinkedList<GroupingRequest>();
            query.properties().set(PROP_REQUEST, lst);
        }
        GroupingRequest ret = new GroupingRequest(lst.size());
        lst.add(ret);
        return ret;
    }

    public static List<GroupingRequest> getRequests(Query query) {
        Object lst = query.properties().get(PROP_REQUEST);
        if (lst == null) {
            return Collections.emptyList();
        }
        if (!(lst instanceof List)) {
            throw new IllegalArgumentException("Expected " + GroupingRequest.class + ", got " + lst.getClass() + ".");
        }
        return (List)lst;
    }
}

