/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.net.HostName;
import com.yahoo.prelude.Ping;
import com.yahoo.prelude.Pong;
import com.yahoo.prelude.fastsearch.FS4ResourcePool;
import com.yahoo.prelude.fastsearch.FastSearcher;
import com.yahoo.search.cluster.ClusterMonitor;
import com.yahoo.search.cluster.NodeManager;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Beta
public class SearchCluster
implements NodeManager<Node> {
    private static final Logger log = Logger.getLogger(SearchCluster.class.getName());
    private double minActivedocsCoveragePercentage;
    private final int size;
    private final ImmutableMap<Integer, Group> groups;
    private final ImmutableMultimap<String, Node> nodesByHost;
    private final ClusterMonitor<Node> clusterMonitor;
    private final VipStatus vipStatus;
    private final Optional<Node> directDispatchTarget;
    private final FS4ResourcePool fs4ResourcePool;

    public SearchCluster(DispatchConfig dispatchConfig, FS4ResourcePool fs4ResourcePool, int containerClusterSize, VipStatus vipStatus) {
        this(dispatchConfig.minActivedocsPercentage(), (List<Node>)SearchCluster.toNodes(dispatchConfig), fs4ResourcePool, containerClusterSize, vipStatus);
    }

    public SearchCluster(double minActivedocsCoverage, List<Node> nodes, FS4ResourcePool fs4ResourcePool, int containerClusterSize, VipStatus vipStatus) {
        this.minActivedocsCoveragePercentage = minActivedocsCoverage;
        this.size = nodes.size();
        this.fs4ResourcePool = fs4ResourcePool;
        this.vipStatus = vipStatus;
        ImmutableMap.Builder groupsBuilder = new ImmutableMap.Builder();
        for (Map.Entry<Integer, List<Node>> group : nodes.stream().collect(Collectors.groupingBy(Node::group)).entrySet()) {
            groupsBuilder.put((Object)group.getKey(), (Object)new Group(group.getKey(), group.getValue()));
        }
        this.groups = groupsBuilder.build();
        ImmutableMultimap.Builder nodesByHostBuilder = new ImmutableMultimap.Builder();
        for (Node node : nodes) {
            nodesByHostBuilder.put((Object)node.hostname(), (Object)node);
        }
        this.nodesByHost = nodesByHostBuilder.build();
        this.directDispatchTarget = SearchCluster.findDirectDispatchTarget(HostName.getLocalhost(), this.size, containerClusterSize, this.nodesByHost, this.groups);
        this.clusterMonitor = new ClusterMonitor<Node>(this);
        for (Node node : nodes) {
            this.working(node);
            this.clusterMonitor.add(node, true);
        }
    }

    private static Optional<Node> findDirectDispatchTarget(String selfHostname, int searchClusterSize, int containerClusterSize, ImmutableMultimap<String, Node> nodesByHost, ImmutableMap<Integer, Group> groups) {
        ImmutableCollection localSearchNodes = nodesByHost.get((Object)selfHostname);
        if (localSearchNodes.size() != 1) {
            return Optional.empty();
        }
        Node localSearchNode = (Node)localSearchNodes.iterator().next();
        Group localSearchGroup = (Group)groups.get((Object)localSearchNode.group());
        if (localSearchGroup.nodes().size() != 1) {
            return Optional.empty();
        }
        if (containerClusterSize < searchClusterSize) {
            return Optional.empty();
        }
        return Optional.of(localSearchNode);
    }

    private static ImmutableList<Node> toNodes(DispatchConfig dispatchConfig) {
        ImmutableList.Builder nodesBuilder = new ImmutableList.Builder();
        for (DispatchConfig.Node node : dispatchConfig.node()) {
            nodesBuilder.add((Object)new Node(node.host(), node.fs4port(), node.group()));
        }
        return nodesBuilder.build();
    }

    public int size() {
        return this.size;
    }

    public ImmutableMap<Integer, Group> groups() {
        return this.groups;
    }

    public int groupSize() {
        if (this.groups.size() == 0) {
            return this.size();
        }
        return this.size() / this.groups.size();
    }

    public ImmutableMultimap<String, Node> nodesByHost() {
        return this.nodesByHost;
    }

    public Optional<Node> directDispatchTarget() {
        if (!this.directDispatchTarget.isPresent()) {
            return Optional.empty();
        }
        Group localSearchGroup = (Group)this.groups.get((Object)this.directDispatchTarget.get().group());
        if (!localSearchGroup.hasSufficientCoverage()) {
            return Optional.empty();
        }
        if (!this.directDispatchTarget.get().isWorking()) {
            return Optional.empty();
        }
        return this.directDispatchTarget;
    }

    @Override
    public void working(Node node) {
        node.setWorking(true);
        if (this.usesDirectDispatchTo(node)) {
            this.vipStatus.addToRotation((Object)this);
        }
    }

    @Override
    public void failed(Node node) {
        node.setWorking(false);
        if (this.usesDirectDispatchTo(node)) {
            this.vipStatus.removeFromRotation((Object)this);
        }
    }

    private void updateSufficientCoverage(Group group, boolean sufficientCoverage) {
        if (this.usesDirectDispatchTo(group) && sufficientCoverage != group.hasSufficientCoverage()) {
            if (sufficientCoverage) {
                this.vipStatus.addToRotation((Object)this);
            } else {
                this.vipStatus.removeFromRotation((Object)this);
            }
        }
        group.setHasSufficientCoverage(sufficientCoverage);
    }

    private boolean usesDirectDispatchTo(Node node) {
        if (!this.directDispatchTarget.isPresent()) {
            return false;
        }
        return this.directDispatchTarget.get().equals(node);
    }

    private boolean usesDirectDispatchTo(Group group) {
        if (!this.directDispatchTarget.isPresent()) {
            return false;
        }
        return this.directDispatchTarget.get().group() == group.id();
    }

    @Override
    public void ping(Node node, Executor executor) {
        Pinger pinger = new Pinger(node);
        FutureTask<Pong> futurePong = new FutureTask<Pong>(pinger);
        executor.execute(futurePong);
        Pong pong = this.getPong(futurePong, node);
        futurePong.cancel(true);
        if (pong.badResponse()) {
            this.clusterMonitor.failed(node, pong.getError(0));
        } else {
            this.clusterMonitor.responded(node);
        }
    }

    @Override
    public void pingIterationCompleted() {
        for (Group group : this.groups.values()) {
            group.aggregateActiveDocuments();
        }
        if (this.groups.size() == 1) {
            this.updateSufficientCoverage((Group)this.groups.values().iterator().next(), true);
        } else {
            for (Group currentGroup : this.groups.values()) {
                long sumOfAactiveDocumentsInOtherGroups = 0L;
                for (Group otherGroup : this.groups.values()) {
                    if (otherGroup == currentGroup) continue;
                    sumOfAactiveDocumentsInOtherGroups += otherGroup.getActiveDocuments();
                }
                long averageDocumentsInOtherGroups = sumOfAactiveDocumentsInOtherGroups / (long)(this.groups.size() - 1);
                if (averageDocumentsInOtherGroups == 0L) {
                    this.updateSufficientCoverage(currentGroup, true);
                    continue;
                }
                this.updateSufficientCoverage(currentGroup, 100.0 * (double)currentGroup.getActiveDocuments() / (double)averageDocumentsInOtherGroups > this.minActivedocsCoveragePercentage);
            }
        }
    }

    private Pong getPong(FutureTask<Pong> futurePong, Node node) {
        try {
            return futurePong.get(this.clusterMonitor.getConfiguration().getFailLimit(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Exception pinging " + node, e);
            return new Pong(ErrorMessage.createUnspecifiedError("Ping was interrupted: " + node));
        }
        catch (ExecutionException e) {
            log.log(Level.WARNING, "Exception pinging " + node, e);
            return new Pong(ErrorMessage.createUnspecifiedError("Execution was interrupted: " + node));
        }
        catch (TimeoutException e) {
            return new Pong(ErrorMessage.createNoAnswerWhenPingingNode("Ping thread timed out"));
        }
    }

    public static class Node {
        private final String hostname;
        private final int fs4port;
        private final int group;
        private final AtomicBoolean working = new AtomicBoolean(true);
        private final AtomicLong activeDocuments = new AtomicLong(0L);

        public Node(String hostname, int fs4port, int group) {
            this.hostname = hostname;
            this.fs4port = fs4port;
            this.group = group;
        }

        public String hostname() {
            return this.hostname;
        }

        public int fs4port() {
            return this.fs4port;
        }

        public int group() {
            return this.group;
        }

        void setWorking(boolean working) {
            this.working.lazySet(working);
        }

        public boolean isWorking() {
            return this.working.get();
        }

        void setActiveDocuments(long activeDocuments) {
            this.activeDocuments.set(activeDocuments);
        }

        public long getActiveDocuments() {
            return this.activeDocuments.get();
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.fs4port);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!Objects.equals(this.hostname, other.hostname)) {
                return false;
            }
            return Objects.equals(this.fs4port, other.fs4port);
        }

        public String toString() {
            return "search node " + this.hostname + ":" + this.fs4port + " in group " + this.group;
        }
    }

    public static class Group {
        private final int id;
        private final ImmutableList<Node> nodes;
        private final AtomicBoolean hasSufficientCoverage = new AtomicBoolean(true);
        private final AtomicLong activeDocuments = new AtomicLong(0L);

        public Group(int id, List<Node> nodes) {
            this.id = id;
            this.nodes = ImmutableList.copyOf(nodes);
        }

        public int id() {
            return this.id;
        }

        public ImmutableList<Node> nodes() {
            return this.nodes;
        }

        public boolean hasSufficientCoverage() {
            return this.hasSufficientCoverage.get();
        }

        void setHasSufficientCoverage(boolean sufficientCoverage) {
            this.hasSufficientCoverage.lazySet(sufficientCoverage);
        }

        void aggregateActiveDocuments() {
            long activeDocumentsInGroup = 0L;
            for (Node node : this.nodes) {
                activeDocumentsInGroup += node.getActiveDocuments();
            }
            this.activeDocuments.set(activeDocumentsInGroup);
        }

        long getActiveDocuments() {
            return this.activeDocuments.get();
        }

        public String toString() {
            return "search group " + this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Group)) {
                return false;
            }
            return ((Group)other).id == this.id;
        }
    }

    private class Pinger
    implements Callable<Pong> {
        private final Node node;

        public Pinger(Node node) {
            this.node = node;
        }

        @Override
        public Pong call() {
            try {
                Pong pong = FastSearcher.ping(new Ping(SearchCluster.this.clusterMonitor.getConfiguration().getRequestTimeout()), SearchCluster.this.fs4ResourcePool.getBackend(this.node.hostname(), this.node.fs4port()), this.node.toString());
                if (pong.activeDocuments().isPresent()) {
                    this.node.setActiveDocuments(pong.activeDocuments().get());
                }
                return pong;
            }
            catch (RuntimeException e) {
                return new Pong(ErrorMessage.createBackendCommunicationError("Exception when pinging " + this.node + ": " + Exceptions.toMessageString((Throwable)e)));
            }
        }
    }
}

