/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.compress.CompressionType;
import com.yahoo.jrt.DataValue;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.Int8Value;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.dispatch.Client;
import com.yahoo.search.dispatch.Dispatcher;
import java.util.List;

class RpcClient
implements Client {
    private final Supervisor supervisor = new Supervisor(new Transport());

    RpcClient() {
    }

    @Override
    public Client.NodeConnection createConnection(String hostname, int port) {
        return new RpcNodeConnection(hostname, port, this.supervisor);
    }

    @Override
    public void getDocsums(List<FastHit> hits, Client.NodeConnection node, CompressionType compression, int uncompressedLength, byte[] compressedSlime, Dispatcher.GetDocsumsResponseReceiver responseReceiver, double timeoutSeconds) {
        Request request = new Request("proton.getDocsums");
        request.parameters().add((Value)new Int8Value(compression.getCode()));
        request.parameters().add((Value)new Int32Value(uncompressedLength));
        request.parameters().add((Value)new DataValue(compressedSlime));
        request.setContext(hits);
        RpcNodeConnection rpcNode = (RpcNodeConnection)node;
        rpcNode.invokeAsync(request, timeoutSeconds, new RpcResponseWaiter(rpcNode, responseReceiver));
    }

    private static class RpcResponseWaiter
    implements RequestWaiter {
        private final RpcNodeConnection node;
        private final Dispatcher.GetDocsumsResponseReceiver handler;

        public RpcResponseWaiter(RpcNodeConnection node, Dispatcher.GetDocsumsResponseReceiver handler) {
            this.node = node;
            this.handler = handler;
        }

        public void handleRequestDone(Request requestWithResponse) {
            if (requestWithResponse.isError()) {
                this.handler.receive(Client.GetDocsumsResponseOrError.fromError("Error response from " + this.node + ": " + requestWithResponse.errorMessage()));
                return;
            }
            Values returnValues = requestWithResponse.returnValues();
            if (returnValues.size() < 3) {
                this.handler.receive(Client.GetDocsumsResponseOrError.fromError("Invalid getDocsums response from " + this.node + ": Expected 3 return arguments, got " + returnValues.size()));
                return;
            }
            byte compression = returnValues.get(0).asInt8();
            int uncompressedSize = returnValues.get(1).asInt32();
            byte[] compressedSlimeBytes = returnValues.get(2).asData();
            List hits = (List)requestWithResponse.getContext();
            this.handler.receive(Client.GetDocsumsResponseOrError.fromResponse(new Client.GetDocsumsResponse(compression, uncompressedSize, compressedSlimeBytes, hits)));
        }
    }

    private static class RpcNodeConnection
    implements Client.NodeConnection {
        private final Supervisor supervisor;
        private final String hostname;
        private final int port;
        private final String description;
        private Target target = null;

        public RpcNodeConnection(String hostname, int port, Supervisor supervisor) {
            this.supervisor = supervisor;
            this.hostname = hostname;
            this.port = port;
            this.description = "rpc node connection to " + hostname + ":" + port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeAsync(Request req, double timeout, RequestWaiter waiter) {
            RpcNodeConnection rpcNodeConnection = this;
            synchronized (rpcNodeConnection) {
                if (this.target == null || !this.target.isValid()) {
                    this.target = this.supervisor.connect(new Spec(this.hostname, this.port));
                }
            }
            this.target.invokeAsync(req, timeout, waiter);
        }

        @Override
        public void close() {
            this.target.close();
        }

        public String toString() {
            return this.description;
        }
    }
}

