/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.compress.CompressionType;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.dispatch.Dispatcher;
import java.util.List;
import java.util.Optional;

interface Client {
    public void getDocsums(List<FastHit> var1, NodeConnection var2, CompressionType var3, int var4, byte[] var5, Dispatcher.GetDocsumsResponseReceiver var6, double var7);

    public NodeConnection createConnection(String var1, int var2);

    public static interface NodeConnection {
        public void close();
    }

    public static class GetDocsumsResponse {
        private final byte compression;
        private final int uncompressedSize;
        private final byte[] compressedSlimeBytes;
        private final List<FastHit> hitsContext;

        public GetDocsumsResponse(byte compression, int uncompressedSize, byte[] compressedSlimeBytes, List<FastHit> hitsContext) {
            this.compression = compression;
            this.uncompressedSize = uncompressedSize;
            this.compressedSlimeBytes = compressedSlimeBytes;
            this.hitsContext = hitsContext;
        }

        public byte compression() {
            return this.compression;
        }

        public int uncompressedSize() {
            return this.uncompressedSize;
        }

        public byte[] compressedSlimeBytes() {
            return this.compressedSlimeBytes;
        }

        public List<FastHit> hitsContext() {
            return this.hitsContext;
        }
    }

    public static class GetDocsumsResponseOrError {
        private Optional<GetDocsumsResponse> response;
        private Optional<String> error;

        public static GetDocsumsResponseOrError fromResponse(GetDocsumsResponse response) {
            return new GetDocsumsResponseOrError(Optional.of(response), Optional.empty());
        }

        public static GetDocsumsResponseOrError fromError(String error) {
            return new GetDocsumsResponseOrError(Optional.empty(), Optional.of(error));
        }

        private GetDocsumsResponseOrError(Optional<GetDocsumsResponse> response, Optional<String> error) {
            this.response = response;
            this.error = error;
        }

        public Optional<GetDocsumsResponse> response() {
            return this.response;
        }

        public Optional<String> error() {
            return this.error;
        }
    }
}

