/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.protect.Validator;
import com.yahoo.search.debug.DebugMethodHandler;
import com.yahoo.search.debug.JrtMethodSignature;
import com.yahoo.search.debug.SearchChainTextRepresentation;
import com.yahoo.search.debug.SearcherUtils;
import com.yahoo.search.handler.SearchHandler;
import com.yahoo.search.searchchain.SearchChain;
import com.yahoo.search.searchchain.SearchChainRegistry;
import com.yahoo.yolean.Exceptions;

final class OutputSearchChain
implements DebugMethodHandler {
    OutputSearchChain() {
    }

    private String getSearchChainName(Request request) {
        int numParameters = request.parameters().size();
        if (numParameters == 0) {
            return "default";
        }
        if (numParameters == 1) {
            return request.parameters().get(0).asString();
        }
        throw new RuntimeException("Too many parameters given.");
    }

    private SearchChain getSearchChain(SearchChainRegistry registry, String searchChainName) {
        SearchChain searchChain = registry.getComponent(searchChainName);
        Validator.ensureNotNull((String)("There is no search chain named '" + searchChainName + "'"), (Object)((Object)searchChain));
        return searchChain;
    }

    @Override
    public JrtMethodSignature getSignature() {
        String returnTypes = "s";
        String parametersTypes = "*";
        return new JrtMethodSignature(returnTypes, parametersTypes);
    }

    public void invoke(Request request) {
        try {
            SearchHandler searchHandler = SearcherUtils.getSearchHandler();
            SearchChainRegistry searchChainRegistry = searchHandler.getSearchChainRegistry();
            SearchChain searchChain = this.getSearchChain(searchChainRegistry, this.getSearchChainName(request));
            SearchChainTextRepresentation textRepresentation = new SearchChainTextRepresentation(searchChain, searchChainRegistry);
            request.returnValues().add((Value)new StringValue(textRepresentation.toString()));
        }
        catch (Exception e) {
            request.setError(1000, Exceptions.toMessageString((Throwable)e));
        }
    }
}

