/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import com.yahoo.container.osgi.AbstractRpcAdaptor;
import com.yahoo.fs4.PacketDumper;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.MethodHandler;
import com.yahoo.jrt.Supervisor;
import com.yahoo.search.debug.BackendStatistics;
import com.yahoo.search.debug.DebugMethodHandler;
import com.yahoo.search.debug.JrtMethodSignature;
import com.yahoo.search.debug.OutputSearchChain;
import com.yahoo.search.debug.TracePackets;

public final class DebugRpcAdaptor
extends AbstractRpcAdaptor {
    private static final String debugPrefix = "debug.";

    public void bindCommands(Supervisor supervisor) {
        this.addTraceMethod(supervisor, "query", PacketDumper.PacketType.query);
        this.addTraceMethod(supervisor, "result", PacketDumper.PacketType.result);
        this.addMethod(supervisor, "output-search-chain", new OutputSearchChain());
        this.addMethod(supervisor, "backend-statistics", new BackendStatistics());
    }

    private void addTraceMethod(Supervisor supervisor, String name, PacketDumper.PacketType packetType) {
        this.addMethod(supervisor, this.constructTraceMethodName(name), new TracePackets(packetType));
    }

    private void addMethod(Supervisor supervisor, String name, DebugMethodHandler handler) {
        JrtMethodSignature typeStrings = handler.getSignature();
        supervisor.addMethod(new Method(debugPrefix + name, typeStrings.parametersTypes, typeStrings.returnTypes, (MethodHandler)handler));
    }

    private String constructTraceMethodName(String name) {
        return "debug.dump-" + name + "-packets";
    }
}

