/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.debug;

import com.yahoo.fs4.mplex.Backend;
import com.yahoo.jrt.Int32Array;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Value;
import com.yahoo.jrt.Values;
import com.yahoo.prelude.cluster.ClusterSearcher;
import com.yahoo.search.debug.DebugMethodHandler;
import com.yahoo.search.debug.JrtMethodSignature;
import com.yahoo.search.debug.SearcherUtils;
import com.yahoo.yolean.Exceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class BackendStatistics
implements DebugMethodHandler {
    @Override
    public JrtMethodSignature getSignature() {
        String returnTypes = "SII";
        String parametersTypes = "s";
        return new JrtMethodSignature(returnTypes, parametersTypes);
    }

    public void invoke(Request request) {
        try {
            Collection<ClusterSearcher> searchers = SearcherUtils.clusterSearchers(request);
            ArrayList<String> backendIdentificators = new ArrayList<String>();
            ArrayList<Integer> activeConnections = new ArrayList<Integer>();
            ArrayList<Integer> totalConnections = new ArrayList<Integer>();
            for (ClusterSearcher searcher : searchers) {
                for (Map.Entry<String, Backend.BackendStatistics> statistics : searcher.getBackendStatistics().entrySet()) {
                    backendIdentificators.add(statistics.getKey());
                    activeConnections.add(statistics.getValue().activeConnections);
                    totalConnections.add(statistics.getValue().totalConnections());
                }
            }
            Values returnValues = request.returnValues();
            returnValues.add((Value)new StringArray(backendIdentificators.toArray(new String[0])));
            this.addInt32Array(returnValues, activeConnections);
            this.addInt32Array(returnValues, totalConnections);
        }
        catch (Exception e) {
            request.setError(1000, Exceptions.toMessageString((Throwable)e));
        }
    }

    private void addInt32Array(Values returnValues, List<Integer> ints) {
        returnValues.add((Value)new Int32Array(ArrayUtils.toPrimitive((Integer[])ints.toArray(new Integer[0]))));
    }
}

