/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.statistics;

import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.container.Server;
import com.yahoo.container.protect.Error;
import com.yahoo.jdisc.Metric;
import com.yahoo.log.LogLevel;
import com.yahoo.metrics.simple.MetricReceiver;
import com.yahoo.metrics.simple.MetricSettings;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Callback;
import com.yahoo.statistics.Counter;
import com.yahoo.statistics.Handle;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

@Before(value={"rawQuery"})
public class StatisticsSearcher
extends Searcher {
    private static final String MAX_QUERY_LATENCY_METRIC = "max_query_latency";
    private static final String EMPTY_RESULTS_METRIC = "empty_results";
    private static final String HITS_PER_QUERY_METRIC = "hits_per_query";
    private static final String TOTALHITS_PER_QUERY_METRIC = "totalhits_per_query";
    private static final String FAILED_QUERIES_METRIC = "failed_queries";
    private static final String MEAN_QUERY_LATENCY_METRIC = "mean_query_latency";
    private static final String QUERY_LATENCY_METRIC = "query_latency";
    private static final String QUERIES_METRIC = "queries";
    private static final String ACTIVE_QUERIES_METRIC = "active_queries";
    private static final String PEAK_QPS_METRIC = "peak_qps";
    private Counter queries;
    private Counter failedQueries;
    private Counter nullQueries;
    private Counter illegalQueries;
    private Value queryLatency;
    private Value queryLatencyBuckets;
    private Value maxQueryLatency;
    private Value activeQueries;
    private Value peakQPS;
    private Counter emptyResults;
    private Value hitsPerQuery;
    private long prevMaxQPSTime;
    private double queriesForQPS = 0.0;
    private final Object peakQpsLock = new Object();
    private Metric metric;
    private Map<String, Metric.Context> chainContexts = new CopyOnWriteHashMap();
    private Map<String, Metric.Context> statePageOnlyContexts = new CopyOnWriteHashMap();

    private void initEvents(Statistics manager, MetricReceiver metricReceiver) {
        this.queries = new Counter(QUERIES_METRIC, manager, false);
        this.failedQueries = new Counter(FAILED_QUERIES_METRIC, manager, false);
        this.nullQueries = new Counter("null_queries", manager, false);
        this.illegalQueries = new Counter("illegal_queries", manager, false);
        this.queryLatency = new Value(MEAN_QUERY_LATENCY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.maxQueryLatency = new Value(MAX_QUERY_LATENCY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMax(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.queryLatencyBuckets = Value.buildValue((String)QUERY_LATENCY_METRIC, (Statistics)manager, null);
        this.activeQueries = new Value(ACTIVE_QUERIES_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(true)).setCallback((Callback)new ActivitySampler()));
        this.peakQPS = new Value(PEAK_QPS_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMax(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.hitsPerQuery = new Value(HITS_PER_QUERY_METRIC, manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(false)));
        this.emptyResults = new Counter(EMPTY_RESULTS_METRIC, manager, false);
        metricReceiver.declareGauge(QUERY_LATENCY_METRIC, Optional.empty(), new MetricSettings.Builder().histogram(true).build());
    }

    StatisticsSearcher(Metric metric) {
        this(Statistics.nullImplementation, metric, MetricReceiver.nullImplementation);
    }

    public StatisticsSearcher(Statistics manager, Metric metric, MetricReceiver metricReceiver) {
        this.metric = metric;
        this.initEvents(manager, metricReceiver);
    }

    public String getMyID() {
        return this.getId().stringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void qps(long now, Metric.Context metricContext) {
        Object object = this.peakQpsLock;
        synchronized (object) {
            if (now - this.prevMaxQPSTime >= 1000L) {
                double ms = now - this.prevMaxQPSTime;
                double peakQPS = this.queriesForQPS / (ms / 1000.0);
                this.peakQPS.put(peakQPS);
                this.metric.set(PEAK_QPS_METRIC, (Number)peakQPS, metricContext);
                this.queriesForQPS = 1.0;
                this.prevMaxQPSTime = now;
            } else {
                this.queriesForQPS += 1.0;
            }
        }
    }

    private Metric.Context getChainMetricContext(String chainName) {
        Metric.Context context = this.chainContexts.get(chainName);
        if (context == null) {
            HashMap<String, String> dimensions = new HashMap<String, String>();
            dimensions.put("chain", chainName);
            context = this.metric.createContext(dimensions);
            this.chainContexts.put(chainName, context);
        }
        return context;
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result;
        Metric.Context metricContext = this.getChainMetricContext(execution.chain().getId().stringValue());
        this.incrQueryCount(metricContext);
        this.logQuery(query);
        long start = System.currentTimeMillis();
        this.qps(start, metricContext);
        try {
            result = execution.search(query);
        }
        catch (Exception e) {
            this.incrErrorCount(null, metricContext);
            throw e;
        }
        long end = System.currentTimeMillis();
        long latency = end - start;
        if (latency >= 0L) {
            this.addLatency(latency, metricContext);
        } else {
            this.getLogger().log(LogLevel.WARNING, "Apparently negative latency measure, start: " + start + ", end: " + end + ", for query: " + query.toString());
        }
        if (result.hits().getError() != null) {
            this.incrErrorCount(result, metricContext);
            this.incrementStatePageOnlyErrors(result, execution);
        }
        int hitCount = result.getConcreteHitCount();
        this.hitsPerQuery.put((double)hitCount);
        this.metric.set(HITS_PER_QUERY_METRIC, (Number)hitCount, metricContext);
        this.metric.set(TOTALHITS_PER_QUERY_METRIC, (Number)result.getTotalHitCount(), metricContext);
        if (hitCount == 0) {
            this.emptyResults.increment();
            this.metric.add(EMPTY_RESULTS_METRIC, (Number)1, metricContext);
        }
        return result;
    }

    private void logQuery(Query query) {
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Query: " + query.toString());
        }
    }

    private void addLatency(long latency, Metric.Context metricContext) {
        this.queryLatency.put((double)latency);
        this.metric.set(QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.metric.set(MEAN_QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.maxQueryLatency.put((double)latency);
        this.metric.set(MAX_QUERY_LATENCY_METRIC, (Number)latency, metricContext);
        this.queryLatencyBuckets.put((double)latency);
    }

    private void incrQueryCount(Metric.Context metricContext) {
        this.queries.increment();
        this.metric.add(QUERIES_METRIC, (Number)1, metricContext);
    }

    private void incrErrorCount(Result result, Metric.Context metricContext) {
        this.failedQueries.increment();
        this.metric.add(FAILED_QUERIES_METRIC, (Number)1, metricContext);
        if (result == null) {
            this.metric.add("error.unhandled_exception", (Number)1, metricContext);
        } else if (result.hits().getErrorHit().hasOnlyErrorCode(Error.NULL_QUERY.code)) {
            this.nullQueries.increment();
        } else if (result.hits().getErrorHit().hasOnlyErrorCode(Error.ILLEGAL_QUERY.code)) {
            this.illegalQueries.increment();
        }
    }

    private void incrementStatePageOnlyErrors(Result result, Execution execution) {
        if (result == null) {
            return;
        }
        ErrorHit error = result.hits().getErrorHit();
        if (error == null) {
            return;
        }
        for (ErrorMessage m : error.errors()) {
            int code = m.getCode();
            Metric.Context c = this.getDimensions(m.getSource(), result, execution);
            if (code == Error.TIMEOUT.code) {
                this.metric.add("error.timeout", (Number)1, c);
                continue;
            }
            if (code == Error.NO_BACKENDS_IN_SERVICE.code) {
                this.metric.add("error.backends_oos", (Number)1, c);
                continue;
            }
            if (code == Error.ERROR_IN_PLUGIN.code) {
                this.metric.add("error.plugin_failure", (Number)1, c);
                continue;
            }
            if (code == Error.BACKEND_COMMUNICATION_ERROR.code) {
                this.metric.add("error.backend_communication_error", (Number)1, c);
                continue;
            }
            if (code == Error.EMPTY_DOCUMENTS.code) {
                this.metric.add("error.empty_document_summaries", (Number)1, c);
                continue;
            }
            if (code == Error.ILLEGAL_QUERY.code) {
                this.metric.add("error.illegal_query", (Number)1, c);
                continue;
            }
            if (code == Error.INVALID_QUERY_PARAMETER.code) {
                this.metric.add("error.invalid_query_parameter", (Number)1, c);
                continue;
            }
            if (code == Error.INTERNAL_SERVER_ERROR.code) {
                this.metric.add("error.internal_server_error", (Number)1, c);
                continue;
            }
            if (code == Error.SERVER_IS_MISCONFIGURED.code) {
                this.metric.add("error.misconfigured_server", (Number)1, c);
                continue;
            }
            if (code == Error.INVALID_QUERY_TRANSFORMATION.code) {
                this.metric.add("error.invalid_query_transformation", (Number)1, c);
                continue;
            }
            if (code == Error.RESULT_HAS_ERRORS.code) {
                this.metric.add("error.result_with_errors", (Number)1, c);
                continue;
            }
            if (code != Error.UNSPECIFIED.code) continue;
            this.metric.add("error.unspecified", (Number)1, c);
        }
    }

    private Metric.Context getDimensions(String source, Result r, Execution execution) {
        Metric.Context context = this.statePageOnlyContexts.get(source == null ? "" : source);
        if (context == null) {
            HashMap<String, String> dims = new HashMap<String, String>();
            if (source != null) {
                dims.put("source", source);
            }
            context = this.metric.createContext(dims);
            this.statePageOnlyContexts.put(source == null ? "" : source, context);
        }
        return context;
    }

    private class ActivitySampler
    implements Callback {
        private ActivitySampler() {
        }

        public void run(Handle h, boolean firstRun) {
            if (firstRun) {
                StatisticsSearcher.this.metric.set(StatisticsSearcher.ACTIVE_QUERIES_METRIC, (Number)0, null);
                return;
            }
            int searchQueriesInFlight = Server.get().searchQueriesInFlight();
            ((Value)h).put((double)searchQueriesInFlight);
            StatisticsSearcher.this.metric.set(StatisticsSearcher.ACTIVE_QUERIES_METRIC, (Number)searchQueriesInFlight, null);
        }
    }
}

