/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.RuleBaseException;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Production;

public class NamespaceProduction
extends Production {
    private String namespace;
    private String key;
    private String value = null;

    public NamespaceProduction(String namespace, String key, String value) {
        this.setNamespace(namespace);
        this.key = key;
        this.value = value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(String namespace) {
        if (!namespace.equals("parameter")) {
            throw new RuleBaseException("Can not produce into namespace '" + namespace + ". Only the 'parameter' name space can be referenced currently");
        }
        this.namespace = namespace;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void produce(RuleEvaluation e, int offset) {
        e.getEvaluation().getQuery().properties().set(this.key, this.value);
    }

    @Override
    public String toInnerString() {
        return this.namespace + "." + this.key + "='" + this.value + "'";
    }
}

