/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.config;

import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.RuleImporter;
import com.yahoo.prelude.semantics.parser.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class RuleConfigDeriver {
    public void derive(String ruleBaseDir, String outputDir) throws IOException, ParseException {
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists()) {
            throw new IOException("Output dir " + outputDirFile.getAbsolutePath() + " does not exist");
        }
        List<RuleBase> ruleBases = this.derive(ruleBaseDir);
        this.exportConfig(ruleBases, outputDir);
    }

    public List<RuleBase> derive(String ruleBaseDir) throws IOException, ParseException {
        boolean ignoreAutomatas = true;
        List<RuleBase> ruleBases = new RuleImporter(ignoreAutomatas).importDir(ruleBaseDir);
        this.ensureZeroOrOneDefault(ruleBases);
        return ruleBases;
    }

    public List<RuleBase> derive(List<NamedReader> readers) throws IOException, ParseException {
        boolean ignoreAutomatas = true;
        ArrayList<RuleBase> ruleBases = new ArrayList<RuleBase>();
        RuleImporter importer = new RuleImporter(ignoreAutomatas);
        for (NamedReader reader : readers) {
            ruleBases.add(importer.importFromReader((Reader)reader, reader.getName(), null));
        }
        this.ensureZeroOrOneDefault(ruleBases);
        return ruleBases;
    }

    private void ensureZeroOrOneDefault(List<RuleBase> ruleBases) throws ParseException {
        String defaultName = null;
        for (RuleBase ruleBase : ruleBases) {
            if (defaultName != null && ruleBase.isDefault()) {
                throw new ParseException("Both '" + defaultName + "' and '" + ruleBase.getName() + "' is marked as default, there can only be one");
            }
            if (!ruleBase.isDefault()) continue;
            defaultName = ruleBase.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportConfig(List<RuleBase> ruleBases, String outputDir) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = IOUtils.createWriter((String)(outputDir + "/semantic-rules.cfg"), (String)"utf-8", (boolean)false);
            writer.write("rulebase[" + ruleBases.size() + "]\n");
            for (int i = 0; i < ruleBases.size(); ++i) {
                RuleBase ruleBase = ruleBases.get(i);
                writer.write("rulebase[" + i + "].name \"" + ruleBase.getName() + "\"\n");
                writer.write("rulebase[" + i + "].rules \"");
                this.writeRuleBaseAsLine(ruleBase.getSource(), writer);
                writer.write("\"\n");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWriter(writer);
            throw throwable;
        }
        IOUtils.closeWriter((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRuleBaseAsLine(String file, Writer writer) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = IOUtils.createReader((String)file, (String)"utf-8");
            while (null != (line = reader.readLine())) {
                writer.write(line);
                writer.write("\\n");
            }
        }
        finally {
            IOUtils.closeReader((Reader)reader);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("USAGE: RuleConfigDeriver ruleBaseDir outputDir");
            System.exit(1);
        }
        try {
            new RuleConfigDeriver().derive(args[0], args[1]);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + RuleConfigDeriver.collectMessage(e));
            System.exit(1);
        }
    }

    private static String collectMessage(Throwable e) {
        if (e.getCause() == null) {
            return RuleConfigDeriver.messageOrName(e);
        }
        return RuleConfigDeriver.messageOrName(e) + ": " + RuleConfigDeriver.collectMessage(e.getCause());
    }

    private static String messageOrName(Throwable e) {
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return e.getClass().getName();
    }
}

