/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics;

import com.google.inject.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.RuleBaseException;
import com.yahoo.prelude.semantics.RuleImporter;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@After(value={"rawQuery"})
@Before(value={"transformedQuery", "Stemming", "MixedRecallRewrite"})
public class SemanticSearcher
extends Searcher {
    private static final CompoundName rulesRulebase = new CompoundName("rules.rulebase");
    private static final CompoundName rulesOff = new CompoundName("rules.off");
    private static final CompoundName tracelevelRules = new CompoundName("tracelevel.rules");
    private RuleBase defaultRuleBase;
    private final Map<String, RuleBase> ruleBases = new HashMap<String, RuleBase>();

    public SemanticSearcher(RuleBase ruleBase) {
        this(Collections.singletonList(ruleBase));
        this.defaultRuleBase = ruleBase;
    }

    public SemanticSearcher(RuleBase ... ruleBases) {
        this(Arrays.asList(ruleBases));
    }

    @Inject
    public SemanticSearcher(SemanticRulesConfig config) {
        this(SemanticSearcher.toList(config));
    }

    public SemanticSearcher(List<RuleBase> ruleBases) {
        for (RuleBase ruleBase : ruleBases) {
            if (ruleBase.isDefault()) {
                this.defaultRuleBase = ruleBase;
            }
            this.ruleBases.put(ruleBase.getName(), ruleBase);
        }
    }

    private static List<RuleBase> toList(SemanticRulesConfig config) {
        try {
            RuleImporter ruleImporter = new RuleImporter(config);
            ArrayList<RuleBase> ruleBaseList = new ArrayList<RuleBase>();
            for (SemanticRulesConfig.Rulebase ruleBaseConfig : config.rulebase()) {
                RuleBase ruleBase = ruleImporter.importConfig(ruleBaseConfig);
                if (ruleBaseConfig.isdefault()) {
                    ruleBase.setDefault(true);
                }
                ruleBaseList.add(ruleBase);
            }
            return ruleBaseList;
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed configuring semantic rules", e);
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        RuleBase ruleBase;
        if (query.properties().getBoolean(rulesOff)) {
            return execution.search(query);
        }
        int traceLevel = query.properties().getInteger(tracelevelRules, query.getTraceLevel() - 2);
        if (traceLevel < 0) {
            traceLevel = 0;
        }
        if ((ruleBase = this.resolveRuleBase(query)) == null) {
            return execution.search(query);
        }
        String error = ruleBase.analyze(query, traceLevel);
        if (error != null) {
            return this.handleError(ruleBase, query, error);
        }
        return execution.search(query);
    }

    private RuleBase resolveRuleBase(Query query) {
        String ruleBaseName = query.properties().getString(rulesRulebase);
        if (ruleBaseName == null || ruleBaseName.equals("")) {
            return this.getDefaultRuleBase();
        }
        RuleBase ruleBase = this.getRuleBase(ruleBaseName);
        if (ruleBase == null) {
            throw new RuleBaseException("Requested rule base '" + ruleBaseName + "' does not exist");
        }
        return ruleBase;
    }

    private Result handleError(RuleBase ruleBase, Query query, String error) {
        String message = "Evaluation of query '" + query.getModel().getQueryTree() + "' over '" + ruleBase + "' caused the invalid query '" + query.getModel().getQueryTree().getRoot() + "': " + error;
        this.getLogger().warning(message);
        return new Result(query, ErrorMessage.createInvalidQueryTransformation(message));
    }

    public RuleBase getDefaultRuleBase() {
        return this.defaultRuleBase;
    }

    public RuleBase getRuleBase(String ruleBaseName) {
        ruleBaseName = RuleImporter.stripLastName(ruleBaseName);
        return this.ruleBases.get(ruleBaseName);
    }
}

