/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.ComponentId;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.hitfield.FieldPart;
import com.yahoo.prelude.hitfield.HitField;
import com.yahoo.prelude.hitfield.ImmutableFieldPart;
import com.yahoo.prelude.hitfield.StringFieldPart;
import com.yahoo.prelude.searcher.QrQuotetableConfig;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.result.Hit;
import com.yahoo.search.searchchain.Execution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class QuotingSearcher
extends Searcher {
    private QuoteTable quoteTable;

    private synchronized void setQuoteTable(QuoteTable quoteTable) {
        this.quoteTable = quoteTable;
    }

    private synchronized QuoteTable getQuoteTable() {
        return this.quoteTable;
    }

    public QuotingSearcher(ComponentId id, QrQuotetableConfig config) {
        super(id);
        this.setQuoteTable(new QuoteTable(config));
    }

    @Override
    public Result search(Query query, Execution execution) {
        Result result = execution.search(query);
        execution.fill(result);
        QuoteTable translations = this.getQuoteTable();
        if (translations == null || translations.isEmpty()) {
            return result;
        }
        Iterator<Hit> i = result.hits().deepIterator();
        while (i.hasNext()) {
            Hit h = i.next();
            if (!(h instanceof FastHit)) continue;
            this.quoteProperties((FastHit)h, translations);
        }
        return result;
    }

    private void quoteProperties(FastHit hit, QuoteTable translations) {
        for (String propertyName : hit.fields().keySet()) {
            Object entry = hit.getField(propertyName);
            if (entry == null) continue;
            Class<?> propertyType = entry.getClass();
            if (propertyType.equals(HitField.class)) {
                this.quoteField((HitField)entry, translations);
                continue;
            }
            if (!propertyType.equals(String.class)) continue;
            this.quoteProperty(hit, propertyName, (String)entry, translations);
        }
    }

    private void quoteProperty(Hit hit, String fieldname, String toQuote, QuoteTable translations) {
        List<FieldPart> l = this.translate(toQuote, translations, true);
        if (l != null) {
            HitField hf = new HitField(fieldname, toQuote);
            hf.setTokenizedContent(l);
            hit.setField(fieldname, hf);
        }
    }

    private void quoteField(HitField field, QuoteTable translations) {
        ListIterator<FieldPart> i = field.listIterator();
        while (i.hasNext()) {
            List<FieldPart> newFieldParts;
            FieldPart f = i.next();
            if (f.isFinal() || (newFieldParts = this.translate(f.getContent(), translations, f.isToken())) == null) continue;
            i.remove();
            Iterator<FieldPart> j = newFieldParts.iterator();
            while (j.hasNext()) {
                i.add(j.next());
            }
        }
    }

    private List<FieldPart> translate(String toQuote, QuoteTable translations, boolean isToken) {
        ArrayList<StringFieldPart> newFieldParts = null;
        int lastIdx = 0;
        for (int i = 0; i < toQuote.length(); ++i) {
            String quote = translations.get(toQuote.charAt(i));
            if (quote == null) continue;
            if (newFieldParts == null) {
                newFieldParts = new ArrayList<StringFieldPart>();
            }
            if (lastIdx != i) {
                newFieldParts.add(new StringFieldPart(toQuote.substring(lastIdx, i), isToken));
            }
            String initContent = Character.toString(toQuote.charAt(i));
            newFieldParts.add((StringFieldPart)((Object)new ImmutableFieldPart(initContent, quote, isToken)));
            lastIdx = i + 1;
        }
        if (lastIdx > 0 && lastIdx < toQuote.length()) {
            newFieldParts.add(new StringFieldPart(toQuote.substring(lastIdx), isToken));
        }
        return newFieldParts;
    }

    private static class QuoteTable {
        private final int lowerUncachedBound;
        private final int upperUncachedBound;
        private final Map<Character, String> quoteMap;
        private final String[] lowerTable;
        private final boolean useMap;
        private final boolean isEmpty;

        public QuoteTable(QrQuotetableConfig config) {
            int minOrd = 0;
            int maxOrd = 0;
            String[] newLowerTable = new String[256];
            boolean newUseMap = false;
            boolean newIsEmpty = true;
            HashMap<Character, String> newQuoteMap = new HashMap<Character, String>();
            for (QrQuotetableConfig.Character character : config.character()) {
                if (character.ordinal() > 256) {
                    newIsEmpty = false;
                    newQuoteMap.put(new Character((char)character.ordinal()), character.quoting());
                    newUseMap = true;
                    if (minOrd == 0 || character.ordinal() < minOrd) {
                        minOrd = character.ordinal();
                    }
                    if (maxOrd != 0 && character.ordinal() <= maxOrd) continue;
                    maxOrd = character.ordinal();
                    continue;
                }
                newIsEmpty = false;
                newLowerTable[character.ordinal()] = character.quoting();
            }
            this.lowerUncachedBound = minOrd;
            this.upperUncachedBound = maxOrd;
            this.quoteMap = newQuoteMap;
            this.useMap = newUseMap;
            this.isEmpty = newIsEmpty;
            this.lowerTable = newLowerTable;
        }

        public String get(char c) {
            if (this.isEmpty) {
                return null;
            }
            char ord = c;
            if (ord < '\u0100') {
                return this.lowerTable[ord];
            }
            if (!this.useMap || ord < this.lowerUncachedBound || ord > this.upperUncachedBound) {
                return null;
            }
            return this.quoteMap.get(new Character(c));
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }
    }
}

