/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.cache.Cache;
import com.yahoo.prelude.cache.QueryCacheKey;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
public class CachingSearcher
extends Searcher {
    private static final CompoundName nocachewrite = new CompoundName("nocachewrite");
    private Cache<QueryCacheKey, Result> cache;
    private Value cacheHitRatio = null;

    public CachingSearcher(QrSearchersConfig config, Statistics manager) {
        long maxSizeBytes = config.com().yahoo().prelude().searcher().CachingSearcher().cachesizemegabytes() * 1024 * 1024;
        long timeToLiveMillis = config.com().yahoo().prelude().searcher().CachingSearcher().timetoliveseconds() * 1000;
        long maxEntrySizeBytes = config.com().yahoo().prelude().searcher().CachingSearcher().maxentrysizebytes();
        this.cache = new Cache(maxSizeBytes, timeToLiveMillis, maxEntrySizeBytes, manager);
        this.initRatio(manager);
    }

    private void initRatio(Statistics manager) {
        this.cacheHitRatio = new Value("querycache_hit_ratio", manager, new Value.Parameters().setNameExtension(Boolean.valueOf(false)).setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)));
    }

    private synchronized void cacheHit() {
        this.cacheHitRatio.put(1.0);
    }

    private synchronized void cacheMiss() {
        this.cacheHitRatio.put(0.0);
    }

    private boolean noCacheWrite(Query query) {
        return query.properties().getBoolean(nocachewrite);
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (query.getNoCache()) {
            return execution.search(query);
        }
        QueryCacheKey queryKey = new QueryCacheKey(query);
        Result cachedResult = this.cache.get(queryKey);
        if (cachedResult != null) {
            this.cacheHit();
            return cachedResult;
        }
        this.cacheMiss();
        Query originalQuery = query.clone();
        Result result = execution.search(query);
        execution.fill(result);
        if (!this.noCacheWrite(query)) {
            queryKey.setQuery(originalQuery);
            this.cache.put(queryKey, result);
        }
        return result;
    }
}

