/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TaggableSegmentItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public abstract class IndexedSegmentItem
extends TaggableSegmentItem
implements IndexedItem {
    @NonNull
    private String index = "";

    protected IndexedSegmentItem(String rawWord, String current, boolean isFromQuery, boolean stemmed, Substring origin) {
        super(rawWord, current, isFromQuery, stemmed, origin);
    }

    @Override
    @NonNull
    public String getIndexName() {
        return this.index;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IndexedSegmentItem.putString(this.index, buffer);
    }

    @Override
    public void setIndexName(String index) {
        if (index == null) {
            index = "";
        }
        this.index = index;
    }

    protected void appendIndexString(StringBuilder buffer) {
        if (!this.getIndexName().equals("")) {
            buffer.append(this.getIndexName());
            buffer.append(":");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        IndexedItem other = (IndexedItem)object;
        return this.index.equals(other.getIndexName());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.index.hashCode();
    }

    @Override
    public abstract String getIndexedString();

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("index", this.index);
    }
}

