/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.collections.TinyIdentitySet;
import com.yahoo.fs4.BasicPacket;
import com.yahoo.fs4.DocsumPacket;
import com.yahoo.fs4.DocumentInfo;
import com.yahoo.fs4.ErrorPacket;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryPacket;
import com.yahoo.fs4.QueryPacketData;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.io.HexDump;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.ConfigurationException;
import com.yahoo.prelude.fastsearch.CacheControl;
import com.yahoo.prelude.fastsearch.CacheKey;
import com.yahoo.prelude.fastsearch.CacheParams;
import com.yahoo.prelude.fastsearch.ClusterParams;
import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocsumPacketKey;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.GroupingListHit;
import com.yahoo.prelude.fastsearch.PacketWrapper;
import com.yahoo.prelude.fastsearch.RankProfile;
import com.yahoo.prelude.fastsearch.SummaryParameters;
import com.yahoo.prelude.fastsearch.TimeoutException;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.textualrepresentation.TextualQueryRepresentation;
import com.yahoo.prelude.querytransform.QueryRewrite;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.protect.Validator;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.cluster.PingableSearcher;
import com.yahoo.search.grouping.vespa.GroupingExecutor;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import com.yahoo.search.result.Relevance;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.Deserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public abstract class VespaBackEndSearcher
extends PingableSearcher {
    private static final CompoundName grouping = new CompoundName("grouping");
    private static final CompoundName combinerows = new CompoundName("combinerows");
    private static final CompoundName dispatchSummaries = new CompoundName("dispatch.summaries");
    protected static final CompoundName PACKET_COMPRESSION_LIMIT = new CompoundName("packetcompressionlimit");
    protected static final CompoundName PACKET_COMPRESSION_TYPE = new CompoundName("packetcompressiontype");
    protected static final CompoundName TRACE_DISABLE = new CompoundName("trace.disable");
    private Map<String, DocumentDatabase> documentDbs = new LinkedHashMap<String, DocumentDatabase>();
    private DocumentDatabase defaultDocumentDb = null;
    private String defaultDocsumClass = null;
    private boolean localDispatching = true;
    private String name;
    protected CacheControl cacheControl = null;
    private int rowBits = 0;
    private int sourceNumber;

    protected Iterator<Hit> hitIterator(Result result) {
        return result.hits().unorderedDeepIterator();
    }

    protected final String getName() {
        return this.name;
    }

    protected final String getDefaultDocsumClass() {
        return this.defaultDocsumClass;
    }

    private void setDefaultDocsumClass(String docsumClass) {
        this.defaultDocsumClass = docsumClass;
    }

    public final CacheControl getCacheControl() {
        return this.cacheControl;
    }

    protected abstract Result doSearch2(Query var1, QueryPacket var2, CacheKey var3, Execution var4);

    protected abstract void doPartialFill(Result var1, String var2);

    protected static boolean wantsRPCSummaryFill(Query query) {
        return query.properties().getBoolean(dispatchSummaries);
    }

    protected boolean summaryNeedsQuery(Query query) {
        if (query.getRanking().getQueryCache()) {
            return false;
        }
        DocumentDatabase documentDb = this.getDocumentDatabase(query);
        DocsumDefinition docsumDefinition = documentDb.getDocsumDefinitionSet().getDocsumDefinition(query.getPresentation().getSummary());
        if (docsumDefinition == null) {
            return true;
        }
        if (docsumDefinition.isDynamic()) {
            return true;
        }
        RankProfile rankProfile = documentDb.rankProfiles().get(query.getRanking().getProfile());
        if (rankProfile == null) {
            return true;
        }
        if (rankProfile.hasSummaryFeatures()) {
            return true;
        }
        return query.getRanking().getListFeatures();
    }

    private Result cacheLookupFirstPhase(CacheKey key, QueryPacketData queryPacketData, Query query, int offset, int hits, String summaryClass) throws IOException {
        PacketWrapper packetWrapper = this.cacheControl.lookup(key, query);
        if (packetWrapper == null) {
            return null;
        }
        List<DocumentInfo> documents = packetWrapper.getDocuments(offset, hits);
        if (documents == null) {
            return null;
        }
        if (query.getPresentation().getSummary() == null) {
            query.getPresentation().setSummary(this.getDefaultDocsumClass());
        }
        Result result = new Result(query);
        QueryResultPacket resultPacket = packetWrapper.getFirstResultPacket();
        this.addMetaInfo(query, queryPacketData, resultPacket, result, true);
        if (packetWrapper.getNumPackets() == 0) {
            this.addUnfilledHits(result, documents, true, queryPacketData, key);
        } else {
            this.addCachedHits(result, packetWrapper, summaryClass, documents);
        }
        return result;
    }

    protected DocumentDatabase getDocumentDatabase(Query query) {
        String docTypeName;
        DocumentDatabase db;
        if (query.getModel().getRestrict().size() == 1 && (db = this.documentDbs.get(docTypeName = (String)query.getModel().getRestrict().toArray()[0])) != null) {
            return db;
        }
        return this.defaultDocumentDb;
    }

    private void resolveDocumentDatabase(Query query) {
        DocumentDatabase docDb = this.getDocumentDatabase(query);
        if (docDb != null) {
            query.getModel().setDocumentDb(docDb.getName());
        }
    }

    public final void init(SummaryParameters docSumParams, ClusterParams clusterParams, CacheParams cacheParams, DocumentdbInfoConfig documentdbInfoConfig) {
        this.name = clusterParams.searcherName;
        this.sourceNumber = clusterParams.clusterNumber;
        this.rowBits = clusterParams.rowBits;
        Validator.ensureNotNull((String)"Name of Vespa backend integration", (Object)this.getName());
        this.setDefaultDocsumClass(docSumParams.defaultClass);
        if (documentdbInfoConfig != null) {
            for (DocumentdbInfoConfig.Documentdb docDb : documentdbInfoConfig.documentdb()) {
                DocumentDatabase db = new DocumentDatabase(docDb, clusterParams.emulation);
                if (this.documentDbs.isEmpty()) {
                    this.defaultDocumentDb = db;
                }
                this.documentDbs.put(docDb.name(), db);
            }
        }
        this.cacheControl = cacheParams.cacheControl == null ? new CacheControl(cacheParams.cacheMegaBytes, cacheParams.cacheTimeOutSeconds) : cacheParams.cacheControl;
    }

    protected void transformQuery(Query query) {
    }

    @Override
    public Result search(Query query, Execution execution) {
        Item root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query, ErrorMessage.createNullQuery(query.getHttpRequest().getUri().toString()));
        }
        if (VespaBackEndSearcher.wantsRPCSummaryFill(query) && this.summaryNeedsQuery(query)) {
            return new Result(query, ErrorMessage.createInvalidQueryParameter("When using dispatch.summaries and your summary/rankprofile require the query,  you need to enable ranking.queryCache."));
        }
        QueryRewrite.optimizeByRestrict(query);
        QueryRewrite.optimizeAndNot(query);
        QueryRewrite.collapseSingleComposites(query);
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        this.resolveDocumentDatabase(query);
        this.transformQuery(query);
        VespaBackEndSearcher.traceQuery(this.name, "search", query, query.getOffset(), query.getHits(), 1, Optional.empty());
        root = query.getModel().getQueryTree().getRoot();
        if (root == null || root instanceof NullItem) {
            return new Result(query);
        }
        QueryPacket queryPacket = QueryPacket.create(query);
        int compressionLimit = query.properties().getInteger(PACKET_COMPRESSION_LIMIT, 0);
        queryPacket.setCompressionLimit(compressionLimit);
        if (compressionLimit != 0) {
            queryPacket.setCompressionType(query.properties().getString(PACKET_COMPRESSION_TYPE, "lz4"));
        }
        if (this.isLoggingFine()) {
            this.getLogger().fine("made QueryPacket: " + queryPacket);
        }
        Result result = null;
        CacheKey cacheKey = null;
        if (this.cacheControl.useCache(query)) {
            cacheKey = new CacheKey(queryPacket);
            result = this.getCached(cacheKey, queryPacket.getQueryPacketData(), query);
        }
        if (result == null) {
            result = this.doSearch2(query, queryPacket, cacheKey, execution);
            if (this.isLoggingFine()) {
                this.getLogger().fine("Result NOT retrieved from cache");
            }
            if (query.getTraceLevel() >= 1) {
                query.trace(this.getName() + " dispatch response: " + result, false, 1);
            }
            result.trace(this.getName());
        }
        return result;
    }

    private Result getCached(CacheKey cacheKey, QueryPacketData queryPacketData, Query query) {
        if (query.getTraceLevel() >= 6) {
            query.trace("Cache key hash: " + cacheKey.hashCode(), 6);
            if (query.getTraceLevel() >= 8) {
                query.trace("Cache key: " + HexDump.toHexString((byte[])cacheKey.getCopyOfFullKey()), 8);
            }
        }
        try {
            Result result = this.cacheLookupFirstPhase(cacheKey, queryPacketData, query, query.getOffset(), query.getHits(), query.getPresentation().getSummary());
            if (result == null) {
                return null;
            }
            if (this.isLoggingFine()) {
                this.getLogger().fine("Result retrieved from cache: " + result);
            }
            if (query.getTraceLevel() >= 1) {
                query.trace(this.getName() + " cached response: " + result, false, 1);
            }
            result.trace(this.getName());
            return result;
        }
        catch (IOException e) {
            Result result = new Result(query);
            if (result.hits().getErrorHit() == null) {
                result.hits().addError(ErrorMessage.createBackendCommunicationError("Fast Search (" + this.getName() + ") failed: " + e.getMessage()));
            }
            if (query.getTraceLevel() >= 1) {
                query.trace(this.getName() + " error response: " + result, false, 1);
            }
            return result;
        }
    }

    private List<Result> partitionHits(Result result, String summaryClass) {
        ArrayList<Result> parts = new ArrayList<Result>();
        TinyIdentitySet queryMap = new TinyIdentitySet(4);
        Iterator<Hit> i = this.hitIterator(result);
        while (i.hasNext()) {
            int idx;
            FastHit fastHit;
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || (fastHit = (FastHit)hit).isFilled(summaryClass)) continue;
            Query q = fastHit.getQuery();
            if (q == null) {
                q = result.hits().getQuery();
            }
            if ((idx = queryMap.indexOf((Object)q)) < 0) {
                idx = queryMap.size();
                Result r = new Result(q);
                parts.add(r);
                queryMap.add((Object)q);
            }
            ((Result)parts.get(idx)).hits().add(fastHit);
        }
        return parts;
    }

    @Override
    public void fill(Result result, String summaryClass, Execution execution) {
        if (result.isFilled(summaryClass)) {
            return;
        }
        List<Result> parts = this.partitionHits(result, summaryClass);
        if (parts.size() > 0) {
            for (Result r : parts) {
                this.doPartialFill(r, summaryClass);
                this.mergeErrorsInto(result, r);
            }
            result.hits().setSorted(false);
            result.analyzeHits();
        }
    }

    private void mergeErrorsInto(Result destination, Result source) {
        ErrorHit eh = source.hits().getErrorHit();
        if (eh != null) {
            for (ErrorMessage error : eh.errors()) {
                destination.hits().addError(error);
            }
        }
    }

    static void traceQuery(String sourceName, String type, Query query, int offset, int hits, int level, Optional<String> quotedSummaryClass) {
        if (query.getTraceLevel() < level || query.properties().getBoolean(TRACE_DISABLE)) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(sourceName).append(" " + type + " to dispatch: ").append("query=[").append(query.getModel().getQueryTree().getRoot().toString()).append("]");
        s.append(" timeout=").append(query.getTimeout()).append("ms");
        s.append(" offset=").append(offset).append(" hits=").append(hits);
        if (query.getRanking().hasRankProfile()) {
            s.append(" rankprofile[").append(query.getRanking().getProfile()).append("]");
        }
        if (query.getRanking().getFreshness() != null) {
            s.append(" freshness=").append(query.getRanking().getFreshness().getRefTime());
        }
        if (query.getRanking().getSorting() != null) {
            s.append(" sortspec=").append(query.getRanking().getSorting().fieldOrders().toString());
        }
        if (query.getRanking().getLocation() != null) {
            s.append(" location=").append(query.getRanking().getLocation().toString());
        }
        if (query.getGroupingSessionCache()) {
            s.append(" groupingSessionCache=true");
        }
        if (query.getRanking().getQueryCache()) {
            s.append(" ranking.queryCache=true");
        }
        if (query.getGroupingSessionCache() || query.getRanking().getQueryCache()) {
            s.append(" sessionId=" + query.getSessionId(true));
        }
        List<Grouping> grouping = GroupingExecutor.getGroupingList(query);
        s.append(" grouping=").append(grouping.size()).append(" : ");
        for (Grouping g : grouping) {
            s.append(g.toString());
        }
        if (!query.getRanking().getProperties().isEmpty()) {
            s.append(" rankproperties=").append(query.getRanking().getProperties().toString());
        }
        if (!query.getRanking().getFeatures().isEmpty()) {
            s.append(" rankfeatures=").append(query.getRanking().getFeatures().toString());
        }
        if (query.getModel().getRestrict() != null) {
            s.append(" restrict=").append(query.getModel().getRestrict().toString());
        }
        if (quotedSummaryClass.isPresent()) {
            s.append(" summary=").append(quotedSummaryClass.get());
        }
        query.trace(s.toString(), false, level);
        if (query.isTraceable(level + 1)) {
            query.trace("Current state of query tree: " + new TextualQueryRepresentation(query.getModel().getQueryTree().getRoot()), false, level + 1);
        }
        if (query.isTraceable(level + 2)) {
            query.trace("YQL+ representation: " + query.yqlRepresentation(), level + 2);
        }
    }

    protected void addMetaInfo(Query query, QueryPacketData queryPacketData, QueryResultPacket resultPacket, Result result, boolean fromCache) {
        result.setTotalHitCount(resultPacket.getTotalDocumentCount());
        if (resultPacket.getGroupData() != null) {
            byte[] data = resultPacket.getGroupData();
            ArrayList<Grouping> list = new ArrayList<Grouping>();
            BufferSerializer buf = new BufferSerializer(new GrowableByteBuffer(ByteBuffer.wrap(data)));
            int cnt = buf.getInt(null);
            for (int i = 0; i < cnt; ++i) {
                Grouping g = new Grouping();
                g.deserialize((Deserializer)buf);
                list.add(g);
            }
            GroupingListHit hit = new GroupingListHit(list, this.getDocsumDefinitionSet(query));
            hit.setQuery(result.getQuery());
            hit.setSource(this.getName());
            hit.setSourceNumber(this.sourceNumber);
            hit.setQueryPacketData(queryPacketData);
            result.hits().add(hit);
        }
        if (resultPacket.getCoverageFeature()) {
            result.setCoverage(new Coverage(resultPacket.getCoverageDocs(), resultPacket.getActiveDocs()).setSoonActive(resultPacket.getSoonActiveDocs()).setDegradedReason(resultPacket.getDegradedReason()));
        }
    }

    private boolean fillHit(FastHit hit, DocsumPacket packet, String summaryClass) {
        byte[] docsumdata;
        if (packet != null && (docsumdata = packet.getData()).length > 0) {
            this.decodeSummary(summaryClass, hit, docsumdata);
            return true;
        }
        return false;
    }

    protected int fillHits(Result result, int packetIndex, Packet[] packets, String summaryClass) throws IOException {
        int skippedHits = 0;
        Iterator<Hit> i = this.hitIterator(result);
        while (i.hasNext()) {
            Hit hit = i.next();
            if (!(hit instanceof FastHit) || hit.isFilled(summaryClass)) continue;
            FastHit fastHit = (FastHit)hit;
            VespaBackEndSearcher.ensureInstanceOf(DocsumPacket.class, packets[packetIndex], this.getName());
            DocsumPacket docsum = (DocsumPacket)packets[packetIndex];
            ++packetIndex;
            if (this.fillHit(fastHit, docsum, summaryClass)) continue;
            ++skippedHits;
        }
        result.hits().setSorted(false);
        return skippedHits;
    }

    protected static void ensureInstanceOf(Class<? extends BasicPacket> type, BasicPacket packet, String name) throws IOException {
        if (type.isAssignableFrom(packet.getClass())) {
            return;
        }
        if (packet instanceof ErrorPacket) {
            ErrorPacket errorPacket = (ErrorPacket)packet;
            if (errorPacket.getErrorCode() == 8) {
                throw new TimeoutException("Query timed out in " + name);
            }
            throw new IOException("Received error from backend in " + name + ": " + packet);
        }
        throw new IOException("Received " + packet + " when expecting " + type);
    }

    private boolean addCachedHits(Result result, PacketWrapper packetWrapper, String summaryClass, List<DocumentInfo> documents) {
        boolean filledAllOfEm = true;
        Query myQuery = result.getQuery();
        for (DocumentInfo document : documents) {
            FastHit hit = new FastHit();
            hit.setQuery(myQuery);
            hit.setUseRowInIndexUri(this.useRowInIndexUri(result));
            hit.setFillable();
            hit.setCached(true);
            this.extractDocumentInfo(hit, document);
            DocsumPacket docsum = (DocsumPacket)packetWrapper.getPacket(document.getGlobalId(), document.getPartId(), summaryClass);
            if (docsum != null) {
                byte[] docsumdata = docsum.getData();
                if (docsumdata.length > 0) {
                    this.decodeSummary(summaryClass, hit, docsumdata);
                } else {
                    filledAllOfEm = false;
                }
            } else {
                filledAllOfEm = false;
            }
            result.hits().add(hit);
        }
        return filledAllOfEm;
    }

    private boolean useRowInIndexUri(Result result) {
        return result.getQuery().properties().getString(grouping) == null && !result.getQuery().properties().getBoolean(combinerows);
    }

    private void extractDocumentInfo(FastHit hit, DocumentInfo document) {
        hit.setSourceNumber(this.sourceNumber);
        hit.setSource(this.getName());
        Double rank = document.getMetric();
        hit.setRelevance(new Relevance(rank));
        hit.setDistributionKey(document.getDistributionKey());
        hit.setGlobalId(document.getGlobalId());
        hit.setPartId(document.getPartId(), this.rowBits);
    }

    protected PacketWrapper cacheLookupTwoPhase(CacheKey cacheKey, Result result, String summaryClass) {
        Query query = result.getQuery();
        PacketWrapper packetWrapper = this.cacheControl.lookup(cacheKey, query);
        if (packetWrapper == null) {
            return null;
        }
        if (packetWrapper.getNumPackets() != 0) {
            Iterator<Hit> i = this.hitIterator(result);
            while (i.hasNext()) {
                DocsumPacketKey key;
                FastHit fastHit;
                Hit hit = i.next();
                if (!(hit instanceof FastHit) || !this.fillHit(fastHit = (FastHit)hit, (DocsumPacket)packetWrapper.getPacket(key = new DocsumPacketKey(fastHit.getGlobalId(), fastHit.getPartId(), summaryClass)), summaryClass)) continue;
                fastHit.setCached(true);
            }
            result.hits().setSorted(false);
            result.analyzeHits();
        }
        return packetWrapper;
    }

    protected DocsumDefinitionSet getDocsumDefinitionSet(Query query) {
        DocumentDatabase db = this.getDocumentDatabase(query);
        return db.getDocsumDefinitionSet();
    }

    private void decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata) {
        DocumentDatabase db = this.getDocumentDatabase(hit.getQuery());
        hit.setField("sddocname", db.getName());
        this.decodeSummary(summaryClass, hit, docsumdata, db.getDocsumDefinitionSet());
    }

    private void decodeSummary(String summaryClass, FastHit hit, byte[] docsumdata, DocsumDefinitionSet docsumSet) {
        docsumSet.lazyDecode(summaryClass, docsumdata, hit);
        hit.setFilled(summaryClass);
    }

    protected boolean addUnfilledHits(Result result, List<DocumentInfo> documents, boolean fromCache, QueryPacketData queryPacketData, CacheKey cacheKey) {
        boolean allHitsOK = true;
        Query myQuery = result.getQuery();
        for (DocumentInfo document : documents) {
            try {
                FastHit hit = new FastHit();
                hit.setQuery(myQuery);
                if (queryPacketData != null) {
                    hit.setQueryPacketData(queryPacketData);
                }
                hit.setCacheKey(cacheKey);
                hit.setUseRowInIndexUri(this.useRowInIndexUri(result));
                hit.setFillable();
                hit.setCached(fromCache);
                this.extractDocumentInfo(hit, document);
                result.hits().add(hit);
            }
            catch (ConfigurationException e) {
                allHitsOK = false;
                this.getLogger().log(LogLevel.WARNING, "Skipping hit", e);
            }
            catch (Exception e) {
                allHitsOK = false;
                this.getLogger().log((Level)LogLevel.ERROR, "Skipping malformed hit", e);
            }
        }
        return allHitsOK;
    }

    public static VespaBackEndSearcher getSearcher(String s) {
        try {
            Class<?> c = Class.forName(s);
            if (VespaBackEndSearcher.class.isAssignableFrom(c)) {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = c.getConstructors()) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    if (parameters.length != 0) continue;
                    return (VespaBackEndSearcher)((Object)constructor.newInstance(new Object[0]));
                }
                throw new RuntimeException("Failed initializing " + s);
            }
            throw new RuntimeException(s + " is not com.yahoo.prelude.fastsearch.VespaBackEndSearcher");
        }
        catch (Exception e) {
            throw new RuntimeException("Failure loading class " + s + ", exception :" + e);
        }
    }

    protected boolean isLoggingFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isLocalDispatching() {
        return this.localDispatching;
    }

    public void setLocalDispatching(boolean localDispatching) {
        this.localDispatching = localDispatching;
    }
}

