/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.simple.Value;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.ByteBuffer;
import java.util.Optional;

public class TensorField
extends DocsumField
implements VariableLengthField {
    public TensorField(String name) {
        super(name);
    }

    public Tensor decode(ByteBuffer buffer) {
        int length = buffer.getInt();
        if (length == 0) {
            return null;
        }
        ByteBuffer contentBuffer = ByteBuffer.wrap(buffer.array(), buffer.arrayOffset() + buffer.position(), length);
        Tensor tensor = TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)new GrowableByteBuffer(contentBuffer));
        buffer.position(buffer.position() + length);
        return tensor;
    }

    public Tensor decode(ByteBuffer b, FastHit hit) {
        Tensor tensor = this.decode(b);
        hit.setField(this.name, tensor);
        return tensor;
    }

    public String toString() {
        return "field " + this.getName() + " type tensor";
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int length = b.getInt();
        b.position(offset + length);
        return length;
    }

    @Override
    public int sizeOfLength() {
        return 4;
    }

    @Override
    public Object convert(Inspector value) {
        byte[] content = value.asData(Value.empty().asData());
        if (content.length == 0) {
            return null;
        }
        return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])content));
    }
}

