/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;

public class StringField
extends DocsumField
implements VariableLengthField {
    public StringField(String name) {
        super(name);
    }

    @Override
    public Object decode(ByteBuffer b) {
        int length = b.getShort() & 0xFFFF;
        String field = Utf8.toString((byte[])b.array(), (int)(b.arrayOffset() + b.position()), (int)length);
        b.position(b.position() + length);
        return field;
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    public String toString() {
        return "field " + this.getName() + " type string";
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int len = b.getShort() & 0xFFFF;
        b.position(offset + len + 2);
        return len + 2;
    }

    @Override
    public int sizeOfLength() {
        return 2;
    }

    @Override
    public Object convert(Inspector value) {
        return value.asString("");
    }
}

