/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.result.NanNumber;
import java.nio.ByteBuffer;

public class ShortField
extends DocsumField {
    static final short EMPTY_VALUE = Short.MIN_VALUE;

    public ShortField(String name) {
        super(name);
    }

    private Object convert(short value) {
        if (value == Short.MIN_VALUE) {
            return NanNumber.NaN;
        }
        return value;
    }

    @Override
    public Object decode(ByteBuffer b) {
        return this.convert(b.getShort());
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int bytelength = 2;
        b.position(offset + 2);
        return 2;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert((short)value.asLong(-32768L));
    }
}

