/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.ArrayTraverser;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.Value;
import com.yahoo.io.SlowInflate;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.prelude.fastsearch.VariableLengthField;
import com.yahoo.prelude.hitfield.JSONString;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;

public class JSONField
extends DocsumField
implements VariableLengthField {
    public JSONField(String name) {
        super(name);
    }

    @Override
    public Object decode(ByteBuffer b) {
        boolean compressed;
        long dataLen = 0L;
        long len = (long)b.getInt() & 0xFFFFFFFFL;
        boolean bl = compressed = (len & Integer.MIN_VALUE) != 0L;
        if (compressed) {
            len &= Integer.MAX_VALUE;
            dataLen = b.getInt();
            len -= 4L;
        }
        byte[] tmp = new byte[(int)len];
        b.get(tmp);
        if (compressed) {
            SlowInflate inf = new SlowInflate();
            tmp = inf.unpack(tmp, (int)dataLen);
        }
        JSONString field = new JSONString(Utf8.toString((byte[])tmp));
        return field;
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    public String toString() {
        return "field " + this.getName() + " type JSONString";
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int len = b.getInt() & Integer.MAX_VALUE;
        b.position(offset + len + 4);
        return len + 4;
    }

    @Override
    public boolean isCompressed(ByteBuffer b) {
        int offset = b.position();
        int compressed = b.getInt() & Integer.MIN_VALUE;
        b.position(offset);
        return compressed != 0;
    }

    @Override
    public int sizeOfLength() {
        return 4;
    }

    static Inspector convertTop(Inspector value) {
        if (value.type() == Type.ARRAY && value.entryCount() > 0) {
            Inspector first = value.entry(0);
            if (first.type() == Type.ARRAY && first.entryCount() == 2) {
                WsConv1 conv = new WsConv1();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.OBJECT && first.fieldCount() == 2 && first.field("item").valid() && first.field("weight").valid()) {
                WsConv2 conv = new WsConv2();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.LONG) {
                ArrConv conv = new ArrConv();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
            if (first.type() == Type.DOUBLE) {
                ArrConv conv = new ArrConv();
                value.traverse((ArrayTraverser)conv);
                return conv.target;
            }
        }
        return value;
    }

    @Override
    public Object convert(Inspector value) {
        if (value.valid()) {
            return new JSONString(JSONField.convertTop(value));
        }
        return new JSONString("");
    }

    private static class WsConv2
    extends CompatibilityConverter
    implements ArrayTraverser {
        private WsConv2() {
        }

        public void entry(int idx, Inspector value) {
            Value.ArrayValue obj = new Value.ArrayValue();
            obj.add(this.stringify(value.field("item")));
            obj.add(value.field("weight"));
            this.target.add((Inspector)obj);
        }
    }

    private static class WsConv1
    extends CompatibilityConverter
    implements ArrayTraverser {
        private WsConv1() {
        }

        public void entry(int idx, Inspector value) {
            Value.ArrayValue obj = new Value.ArrayValue();
            obj.add(this.stringify(value.entry(0)));
            obj.add(value.entry(1));
            this.target.add((Inspector)obj);
        }
    }

    private static class ArrConv
    extends CompatibilityConverter
    implements ArrayTraverser {
        private ArrConv() {
        }

        public void entry(int idx, Inspector value) {
            this.target.add(this.stringify(value));
        }
    }

    private static class CompatibilityConverter {
        Value.ArrayValue target = new Value.ArrayValue();

        private CompatibilityConverter() {
        }

        Inspector stringify(Inspector value) {
            if (value.type() == Type.STRING) {
                return value;
            }
            if (value.type() == Type.LONG) {
                String str = String.valueOf(value.asLong());
                return new Value.StringValue(str);
            }
            if (value.type() == Type.DOUBLE) {
                String str = String.valueOf(value.asDouble());
                return new Value.StringValue(str);
            }
            String str = value.toString();
            return new Value.StringValue(str);
        }
    }
}

