/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.result.NanNumber;
import java.nio.ByteBuffer;

public class FloatField
extends DocsumField {
    static final double EMPTY_VALUE = Double.NaN;

    public FloatField(String name) {
        super(name);
    }

    private Object convert(float value) {
        if (Float.isNaN(value)) {
            return NanNumber.NaN;
        }
        return Float.valueOf(value);
    }

    @Override
    public Object decode(ByteBuffer b) {
        return this.convert(b.getFloat());
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int bytelength = 4;
        b.position(offset + 4);
        return 4;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert((float)value.asDouble(Double.NaN));
    }
}

