/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.result.NanNumber;
import java.nio.ByteBuffer;

public class DoubleField
extends DocsumField {
    static final double EMPTY_VALUE = Double.NaN;

    public DoubleField(String name) {
        super(name);
    }

    private Object convert(double value) {
        if (Double.isNaN(value)) {
            return NanNumber.NaN;
        }
        return value;
    }

    @Override
    public Object decode(ByteBuffer b) {
        return this.convert(b.getDouble());
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        int byteLength = 8;
        b.position(offset + 8);
        return 8;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert(value.asDouble(Double.NaN));
    }
}

