/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.collections.BobHash;
import com.yahoo.fs4.QueryPacket;
import java.util.Arrays;

public class CacheKey {
    private int hashCode;
    private byte[] serialized = null;

    public CacheKey(QueryPacket queryPacket) {
        if (!queryPacket.isEncoded()) {
            queryPacket.allocateAndEncode(0);
        }
        this.serialized = queryPacket.getOpaqueCacheKey();
        this.hashCode = this.calculateHashCode();
    }

    private int calculateHashCode() {
        return BobHash.hash((byte[])this.serialized, (int)0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey k = (CacheKey)o;
        return Arrays.equals(this.serialized, k.serialized);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] getCopyOfFullKey() {
        return Arrays.copyOf(this.serialized, this.serialized.length);
    }

    public int byteSize() {
        return this.serialized.length + 4;
    }
}

