/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.data.access.Inspector;
import com.yahoo.prelude.fastsearch.DocsumField;
import com.yahoo.prelude.fastsearch.FastHit;
import com.yahoo.search.result.NanNumber;
import java.nio.ByteBuffer;

public class ByteField
extends DocsumField {
    static final byte EMPTY_VALUE = -128;

    public ByteField(String name) {
        super(name);
    }

    private Object convert(byte value) {
        if (value == -128) {
            return NanNumber.NaN;
        }
        return value;
    }

    @Override
    public Object decode(ByteBuffer b) {
        return this.convert(b.get());
    }

    @Override
    public Object decode(ByteBuffer b, FastHit hit) {
        Object field = this.decode(b);
        hit.setField(this.name, field);
        return field;
    }

    @Override
    public int getLength(ByteBuffer b) {
        int offset = b.position();
        boolean bytelength = true;
        b.position(offset + 1);
        return 1;
    }

    @Override
    public Object convert(Inspector value) {
        return this.convert((byte)value.asLong(-128L));
    }
}

