/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cluster;

import com.yahoo.log.LogLevel;
import com.yahoo.prelude.fastsearch.VespaBackEndSearcher;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Hasher {
    boolean running = false;
    private static final Logger log = Logger.getLogger(Hasher.class.getName());
    private static final Random tldSeeder = new Random();
    private volatile VespaBackEndSearcher[] allNodes = new VespaBackEndSearcher[0];
    private volatile VespaBackEndSearcher[] localNodes = new VespaBackEndSearcher[0];
    private AtomicInteger avoidAllQrsHitSameTld = new AtomicInteger(Hasher.tldSeed());

    private static synchronized int tldSeed() {
        return tldSeeder.nextInt();
    }

    private static VespaBackEndSearcher[] addNode(VespaBackEndSearcher node, VespaBackEndSearcher[] oldNodes) {
        for (VespaBackEndSearcher n : oldNodes) {
            if (n != node) continue;
            return oldNodes;
        }
        VespaBackEndSearcher[] newNodes = new VespaBackEndSearcher[oldNodes.length + 1];
        System.arraycopy(oldNodes, 0, newNodes, 0, oldNodes.length);
        newNodes[oldNodes.length] = node;
        return newNodes;
    }

    public void add(VespaBackEndSearcher node) {
        this.allNodes = Hasher.addNode(node, this.allNodes);
        if (node.isLocalDispatching()) {
            this.localNodes = Hasher.addNode(node, this.localNodes);
        }
    }

    private VespaBackEndSearcher[] removeNode(VespaBackEndSearcher node, VespaBackEndSearcher[] oldNodes) {
        int newLen = oldNodes.length;
        for (VespaBackEndSearcher n : oldNodes) {
            if (n != node) continue;
            --newLen;
        }
        if (newLen == oldNodes.length) {
            return oldNodes;
        }
        VespaBackEndSearcher[] newNodes = new VespaBackEndSearcher[newLen];
        int idx = 0;
        for (VespaBackEndSearcher n : oldNodes) {
            if (n == node) continue;
            newNodes[idx++] = n;
        }
        assert (idx == newLen);
        return newNodes;
    }

    public void remove(VespaBackEndSearcher node) {
        if (this.allNodes.length == 0) {
            return;
        }
        VespaBackEndSearcher[] newNodes = this.removeNode(node, this.allNodes);
        if (newNodes != this.allNodes) {
            if (this.running && newNodes.length == 0) {
                log.log(LogLevel.WARNING, "No longer any nodes for this cluster when removing malfunctioning " + node.toString() + ".");
            }
            this.allNodes = newNodes;
        }
        if ((newNodes = this.removeNode(node, this.localNodes)) != this.localNodes) {
            if (this.running && this.localNodes.length == 0) {
                log.log(LogLevel.WARNING, "Removing malfunctioning " + node.toString() + " from traffic leaves no local dispatchers, performance degradation is to expected.");
            }
            this.localNodes = newNodes;
        }
    }

    public int getNodeCount() {
        return this.allNodes.length;
    }

    public VespaBackEndSearcher select(int trynum) {
        VespaBackEndSearcher[] nodes = this.allNodes;
        if (this.localNodes.length > 0) {
            nodes = this.localNodes;
        }
        if (nodes.length == 0) {
            return null;
        }
        int idx = 0;
        if (nodes.length > 1) {
            idx = Math.abs(this.avoidAllQrsHitSameTld.incrementAndGet() % nodes.length);
        }
        return nodes[idx];
    }
}

