/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cache;

import com.yahoo.search.Query;

public class QueryCacheKey {
    private Query query;
    private int offset;
    private int hits;

    public QueryCacheKey(Query query) {
        this.query = query;
        this.offset = query.getOffset();
        this.hits = query.getHits();
    }

    public boolean equals(Object key) {
        if (key == null) {
            return false;
        }
        if (this.query == null) {
            return false;
        }
        if (key instanceof QueryCacheKey) {
            QueryCacheKey ckey = (QueryCacheKey)key;
            boolean res = this.equalQueryWith(ckey) && this.equalPathWith(ckey);
            return res;
        }
        return false;
    }

    private boolean equalQueryWith(QueryCacheKey other) {
        return this.query.equals(other.getQuery());
    }

    private boolean equalPathWith(QueryCacheKey other) {
        if (other == null) {
            return false;
        }
        if (other.getQuery() == null) {
            return false;
        }
        return this.query.getHttpRequest().getUri().getPath().equals(other.getQuery().getHttpRequest().getUri().getPath());
    }

    public int getHits() {
        return this.hits;
    }

    public int getOffset() {
        return this.offset;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query newQuery) {
        this.query = newQuery;
    }

    public String toString() {
        if (this.query == null) {
            return super.toString();
        }
        return this.query.toString();
    }

    public int hashCode() {
        if (this.query == null) {
            return super.hashCode();
        }
        int ret = this.query.hashCode();
        return ret;
    }
}

