/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.cache;

import com.yahoo.cache.SizeCalculator;
import com.yahoo.search.Result;
import com.yahoo.statistics.Statistics;
import com.yahoo.statistics.Value;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Cache<K, V> {
    private Value elems = null;
    private Value entrySizes = null;
    private Map<CacheKey<K>, CacheValue<K, V>> content = new LinkedHashMap<CacheKey<K>, CacheValue<K, V>>(12500, 1.0f, true);
    private SizeCalculator calc = new SizeCalculator();
    private long maxSizeBytes;
    private long currentSizeBytes = 0L;
    private long timeToLiveMillis = -1L;
    private long maxEntrySizeBytes = 10000L;

    public Cache(long maxSizeBytes, long timeToLiveMillis, long maxEntrySizeBytes, Statistics manager) {
        this.maxSizeBytes = maxSizeBytes;
        this.timeToLiveMillis = timeToLiveMillis;
        this.maxEntrySizeBytes = maxEntrySizeBytes;
        this.initStats(manager);
    }

    private void initStats(Statistics manager) {
        this.elems = new Value("querycache_elems", manager, new Value.Parameters().setLogRaw(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(true)).setLogMax(Boolean.valueOf(true)));
        this.entrySizes = new Value("querycache_entry_sizes", manager, new Value.Parameters().setLogRaw(Boolean.valueOf(false)).setLogMean(Boolean.valueOf(true)).setNameExtension(Boolean.valueOf(true)).setLogMax(Boolean.valueOf(true)));
    }

    private synchronized CacheValue<K, V> synchGet(CacheKey<K> k) {
        return this.content.get(k);
    }

    private synchronized boolean synchPut(K key, V value, long keySizeBytes, long valueSizeBytes) {
        this.makeRoomForBytes(valueSizeBytes + keySizeBytes);
        CacheKey<K> cacheKey = new CacheKey<K>(keySizeBytes, key);
        CacheValue<K, V> cacheValue = this.timeToLiveMillis < 0L ? new CacheValue<K, V>(valueSizeBytes, value, cacheKey) : new AgingCacheValue<K, V>(valueSizeBytes, value, cacheKey);
        this.currentSizeBytes += valueSizeBytes + keySizeBytes;
        this.elems.put((double)this.content.size());
        this.content.put(cacheKey, cacheValue);
        return true;
    }

    public boolean put(K key, V value) {
        long valueSizeBytes;
        if (value instanceof Result) {
            long totalSizeBytes = this.calc.sizeOf(value);
            if (this.tooBigToCache(totalSizeBytes)) {
                return false;
            }
            this.entrySizes.put((double)totalSizeBytes);
            return this.synchPut(key, value, 0L, totalSizeBytes);
        }
        long keySizeBytes = this.calc.sizeOf(key);
        if (this.tooBigToCache(keySizeBytes + (valueSizeBytes = this.calc.sizeOf(value)))) {
            return false;
        }
        this.entrySizes.put((double)(keySizeBytes + valueSizeBytes));
        return this.synchPut(key, value, keySizeBytes, valueSizeBytes);
    }

    private boolean tooBigToCache(long totalSize) {
        if (totalSize > this.maxEntrySizeBytes) {
            return true;
        }
        return totalSize > this.maxSizeBytes;
    }

    private void makeRoomForBytes(long bytes) {
        if (this.maxSizeBytes - this.currentSizeBytes > bytes) {
            return;
        }
        if (this.content.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<CacheKey<K>, CacheValue<K, V>>> i = this.content.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<CacheKey<K>, CacheValue<K, V>> entry = i.next();
            CacheKey<K> key = entry.getKey();
            CacheValue<K, V> value = entry.getValue();
            i.remove();
            this.currentSizeBytes -= key.sizeBytes();
            this.currentSizeBytes -= value.sizeBytes();
            if (this.maxSizeBytes - this.currentSizeBytes <= bytes) continue;
            break;
        }
    }

    public boolean containsKey(K k) {
        return this.content.containsKey(new CacheKey<K>(-1L, k));
    }

    public V get(K key) {
        CacheKey<K> cacheKey = new CacheKey<K>(-1L, key);
        CacheValue<K, V> value = this.synchGet(cacheKey);
        if (value == null) {
            return null;
        }
        if (this.timeToLiveMillis < 0L) {
            return value.value();
        }
        if (value.expired(this.timeToLiveMillis)) {
            this.remove(key);
            return null;
        }
        return value.value();
    }

    public synchronized boolean remove(K key) {
        CacheValue<K, V> value = this.content.remove(key);
        if (value == null) {
            return false;
        }
        this.currentSizeBytes -= value.sizeBytes();
        this.currentSizeBytes -= value.getKey().sizeBytes();
        this.elems.put((double)this.content.size());
        return true;
    }

    public int size() {
        return this.content.size();
    }

    private static class AgingCacheValue<K, V>
    extends CacheValue<K, V> {
        private long birthTimeMillis = System.currentTimeMillis();

        public AgingCacheValue(long sizeBytes, V value, CacheKey<K> key) {
            super(sizeBytes, value, key);
        }

        public long ageMillis() {
            return System.currentTimeMillis() - this.birthTimeMillis;
        }

        @Override
        public boolean expired(long ttl) {
            return this.ageMillis() >= ttl;
        }
    }

    private static class CacheValue<K, V> {
        private long sizeBytes;
        private V value;
        private CacheKey<K> key;

        public CacheValue(long sizeBytes, V value, CacheKey<K> key) {
            this.sizeBytes = sizeBytes;
            this.value = value;
            this.key = key;
        }

        public boolean expired(long ttl) {
            return false;
        }

        public V value() {
            return this.value;
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }

        public CacheKey<K> getKey() {
            return this.key;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class CacheKey<K> {
        private long sizeBytes;
        private K key;

        public CacheKey(long sizeBytes, K key) {
            this.sizeBytes = sizeBytes;
            this.key = key;
        }

        public long sizeBytes() {
            return this.sizeBytes;
        }

        public K getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object k) {
            if (this.key == null) {
                return false;
            }
            if (k == null) {
                return false;
            }
            if (k instanceof CacheKey) {
                return this.key.equals(((CacheKey)k).getKey());
            }
            return false;
        }

        public String toString() {
            return this.key.toString();
        }
    }
}

