/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.container.QrSearchersConfig;
import com.yahoo.log.LogLevel;
import com.yahoo.prelude.SearchDefinition;
import com.yahoo.search.config.IndexInfoConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class IndexModel {
    private static final Logger log = Logger.getLogger(IndexModel.class.getName());
    private Map<String, List<String>> masterClusters;
    private Map<String, SearchDefinition> searchDefinitions;
    private SearchDefinition unionSearchDefinition;

    public IndexModel(Map<String, List<String>> masterClusters, Map<String, SearchDefinition> searchDefinitions, SearchDefinition unionSearchDefinition) {
        this.masterClusters = masterClusters;
        this.searchDefinitions = searchDefinitions;
        this.unionSearchDefinition = unionSearchDefinition;
    }

    public IndexModel(IndexInfoConfig indexInfo, Map<String, List<String>> clusters) {
        if (indexInfo != null) {
            this.setDefinitions(indexInfo);
        } else {
            this.searchDefinitions = null;
            this.unionSearchDefinition = null;
        }
        this.masterClusters = clusters;
    }

    public IndexModel(IndexInfoConfig indexInfo, QrSearchersConfig clusters) {
        if (indexInfo != null) {
            this.setDefinitions(indexInfo);
        } else {
            this.searchDefinitions = null;
            this.unionSearchDefinition = null;
        }
        if (clusters != null) {
            this.setMasterClusters(clusters);
        } else {
            this.masterClusters = null;
        }
    }

    private void setMasterClusters(QrSearchersConfig config) {
        this.masterClusters = new HashMap<String, List<String>>();
        for (int i = 0; i < config.searchcluster().size(); ++i) {
            ArrayList<String> docTypes = new ArrayList<String>();
            String clusterName = config.searchcluster(i).name();
            for (int j = 0; j < config.searchcluster(i).searchdef().size(); ++j) {
                docTypes.add(config.searchcluster(i).searchdef(j));
            }
            this.masterClusters.put(clusterName, docTypes);
        }
    }

    private void setDefinitions(IndexInfoConfig c) {
        SearchDefinition sd;
        this.searchDefinitions = new HashMap<String, SearchDefinition>();
        this.unionSearchDefinition = new SearchDefinition("unionOfAllKnown");
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = new SearchDefinition(info.name());
            for (IndexInfoConfig.Indexinfo.Command command : info.command()) {
                sd.addCommand(command.indexname(), command.command());
                this.unionSearchDefinition.addCommand(command.indexname(), command.command());
            }
            sd.fillMatchGroups();
            this.searchDefinitions.put(info.name(), sd);
        }
        this.unionSearchDefinition.fillMatchGroups();
        for (IndexInfoConfig.Indexinfo info : c.indexinfo()) {
            sd = this.searchDefinitions.get(info.name());
            for (IndexInfoConfig.Indexinfo.Alias alias : info.alias()) {
                String aliasString = alias.alias();
                String indexString = alias.indexname();
                sd.addAlias(aliasString, indexString);
                try {
                    this.unionSearchDefinition.addAlias(aliasString, indexString);
                }
                catch (RuntimeException e) {
                    log.log(LogLevel.WARNING, "Ignored the alias \"" + aliasString + "\" for \"" + indexString + "\" in the union of all search definitions, source has to be explicitly set to \"" + sd.getName() + "\" for that alias to work.", e);
                }
            }
        }
    }

    public Map<String, List<String>> getMasterClusters() {
        return this.masterClusters;
    }

    public Map<String, SearchDefinition> getSearchDefinitions() {
        return this.searchDefinitions;
    }

    public SearchDefinition getUnionSearchDefinition() {
        return this.unionSearchDefinition;
    }
}

