/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.DocumentInfo;
import com.yahoo.fs4.FS4Properties;
import com.yahoo.fs4.Packet;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryResultPacket
extends Packet {
    private int code;
    private boolean mldFeature = false;
    private boolean datasetFeature = false;
    private boolean coverageFeature = false;
    private boolean coverageExtendedFeature = false;
    private long coverageDocs = 0L;
    private long activeDocs = 0L;
    private long soonActiveDocs = 0L;
    private int degradedReason = 0;
    private boolean groupDataFeature = false;
    private boolean propsFeature = false;
    private long totalDocumentCount;
    private Number maxRank;
    private int docstamp;
    private int dataset = -1;
    private byte[] groupData = null;
    private List<DocumentInfo> documents = new ArrayList<DocumentInfo>(10);
    public FS4Properties[] propsArray;
    private int offset;
    public static final int QRF_MLD = 1;
    public static final int QRF_SORTDATA = 16;
    public static final int QRF_EXTENDED_COVERAGE = 32;
    public static final int QRF_COVERAGE = 64;
    public static final int QRF_GROUPDATA = 512;
    public static final int QRF_PROPERTIES = 1024;

    private QueryResultPacket() {
    }

    public static QueryResultPacket create() {
        return new QueryResultPacket();
    }

    public void setDocstamp(int docstamp) {
        this.docstamp = docstamp;
    }

    public int getDocstamp() {
        return this.docstamp;
    }

    public boolean getMldFeature() {
        return this.mldFeature;
    }

    public boolean getDatasetFeature() {
        return this.datasetFeature;
    }

    public boolean getCoverageFeature() {
        return this.coverageFeature;
    }

    public long getCoverageDocs() {
        return this.coverageDocs;
    }

    public long getActiveDocs() {
        return this.activeDocs;
    }

    public long getSoonActiveDocs() {
        return this.soonActiveDocs;
    }

    public int getDegradedReason() {
        return this.degradedReason;
    }

    public boolean getCoverageFull() {
        return this.coverageDocs == this.activeDocs;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void decodeBody(ByteBuffer buffer) {
        IntBuffer ints = buffer.asIntBuffer();
        this.decodeFeatures(ints);
        this.offset = ints.get();
        int documentCount = ints.get();
        buffer.position(buffer.position() + ints.position() * 4);
        this.totalDocumentCount = buffer.getLong();
        this.maxRank = this.decodeMaxRank(buffer);
        ints = buffer.asIntBuffer();
        this.docstamp = ints.get();
        if (this.datasetFeature) {
            this.dataset = ints.get();
        }
        buffer.position(buffer.position() + ints.position() * 4);
        if (this.groupDataFeature) {
            int len = buffer.getInt();
            this.groupData = new byte[len];
            buffer.get(this.groupData);
        }
        if (this.coverageFeature) {
            this.coverageDocs = buffer.getLong();
            this.activeDocs = buffer.getLong();
        }
        if (this.coverageExtendedFeature) {
            this.soonActiveDocs = buffer.getLong();
            this.degradedReason = buffer.getInt();
        } else {
            this.soonActiveDocs = this.activeDocs;
            this.degradedReason = 0;
        }
        this.decodeDocuments(buffer, documentCount);
        if (this.propsFeature) {
            int numMaps = buffer.getInt();
            this.propsArray = new FS4Properties[numMaps];
            for (int i = 0; i < numMaps; ++i) {
                this.propsArray[i] = new FS4Properties();
                this.propsArray[i].decode(buffer);
            }
        }
    }

    private Number decodeMaxRank(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    private void decodeFeatures(IntBuffer buffer) {
        switch (this.getCode()) {
            case 217: {
                int features = buffer.get();
                this.mldFeature = (1 & features) != 0;
                this.datasetFeature = (2 & features) != 0;
                this.coverageExtendedFeature = (0x20 & features) != 0;
                this.coverageFeature = (0x40 & features) != 0;
                this.groupDataFeature = (0x200 & features) != 0;
                this.propsFeature = (0x400 & features) != 0;
                break;
            }
            default: {
                throw new RuntimeException("Programming error");
            }
        }
    }

    private void decodeDocuments(ByteBuffer buffer, int documentCount) {
        for (int i = 0; i < documentCount; ++i) {
            this.documents.add(new DocumentInfo(buffer, this));
        }
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    protected void codeDecodedHook(int code) {
        this.code = code;
    }

    public int getDocumentCount() {
        return this.documents.size();
    }

    @Override
    public String toString() {
        return "Query result x packet [" + this.getDocumentCount() + " documents]";
    }

    public byte[] getGroupData() {
        return this.groupData;
    }

    public long getTotalDocumentCount() {
        return this.totalDocumentCount;
    }

    public void setTotalDocumentCount(long totalDocumentCount) {
        this.totalDocumentCount = totalDocumentCount;
    }

    public List<DocumentInfo> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public void addDocument(DocumentInfo document) {
        this.documents.add(document);
    }

    public int getMaxRank() {
        return this.maxRank.intValue();
    }

    public int getDataset() {
        return this.dataset;
    }
}

