/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.fs4.BasicPacket;
import java.nio.ByteBuffer;
import java.util.Optional;

public class PongPacket
extends BasicPacket {
    private int lowPartitionId;
    private int dispatchTimestamp;
    private int totalNodes;
    private Optional<Integer> activeNodes = Optional.empty();
    private int totalPartitions;
    private Optional<Integer> activePartitions = Optional.empty();
    private Optional<Long> activeDocuments = Optional.empty();
    private int code;
    static final int MRF_MLD = 1;
    static final int MRF_RFLAGS = 8;
    static final int MRF_ACTIVEDOCS = 16;
    static final int PCODE_MONITORRESULTX = 221;

    public PongPacket() {
    }

    public PongPacket(long activeDocuments) {
        this.activeDocuments = Optional.of(activeDocuments);
    }

    @Override
    protected void codeDecodedHook(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public void decodeBody(ByteBuffer buffer) {
        int features = buffer.getInt();
        this.lowPartitionId = buffer.getInt();
        this.dispatchTimestamp = buffer.getInt();
        if ((features & 1) != 0) {
            this.totalNodes = buffer.getInt();
            this.activeNodes = Optional.of(buffer.getInt());
            this.totalPartitions = buffer.getInt();
            this.activePartitions = Optional.of(buffer.getInt());
        }
        if ((features & 8) != 0) {
            buffer.getInt();
        }
        if ((features & 0x10) != 0) {
            this.activeDocuments = Optional.of(buffer.getLong());
        }
    }

    public static PongPacket create() {
        return new PongPacket();
    }

    public int getDocstamp() {
        return this.dispatchTimestamp;
    }

    public Optional<Long> getActiveDocuments() {
        return this.activeDocuments;
    }

    public Optional<Integer> getActiveNodes() {
        return this.activeNodes;
    }

    public Optional<Integer> getActivePartitions() {
        return this.activePartitions;
    }
}

