/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.document.GlobalId;
import com.yahoo.fs4.Packet;
import java.nio.ByteBuffer;

public class DocsumPacket
extends Packet {
    private GlobalId globalId = new GlobalId(new byte[12]);
    private byte[] data;

    private DocsumPacket() {
    }

    public DocsumPacket(byte[] buffer) {
        this.data = (byte[])buffer.clone();
    }

    public static DocsumPacket create() {
        return new DocsumPacket();
    }

    @Override
    public int getCode() {
        return 205;
    }

    @Override
    public void decodeBody(ByteBuffer buffer) {
        byte[] rawGid = new byte[12];
        buffer.get(rawGid);
        this.globalId = new GlobalId(rawGid);
        this.data = new byte[this.getLength() - 12 - 12];
        buffer.get(this.data);
    }

    public GlobalId getGlobalId() {
        return this.globalId;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "docsum packet [globalId: " + this.globalId.toString() + ", size: " + (this.data == null ? "(no data)" : this.data.length + " bytes") + " ]";
    }
}

