/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.fs4;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.fs4.BufferTooSmallException;
import com.yahoo.fs4.Packet;
import com.yahoo.fs4.QueryResultPacket;
import com.yahoo.log.LogLevel;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public abstract class BasicPacket {
    private final Compressor compressor = new Compressor();
    private static Logger log = Logger.getLogger(QueryResultPacket.class.getName());
    private static int DEFAULT_WRITE_BUFFER_SIZE = 10240;
    public static final int CODE_MASK = 0xFFFFFF;
    protected byte[] encodedBody;
    protected ByteBuffer encodingBuffer;
    protected int length = -1;
    private long timeStamp = -1L;
    private int compressionLimit = 0;
    private CompressionType compressionType;

    public void setCompressionLimit(int limit) {
        this.compressionLimit = limit;
    }

    public void setCompressionType(String type) {
        this.compressionType = CompressionType.valueOf((String)type);
    }

    public BasicPacket decode(ByteBuffer buffer) {
        this.length = buffer.getInt() + 4;
        int code = buffer.getInt();
        this.decodeAndDecompressBody(buffer, code, this.length - 8);
        return this;
    }

    protected void decodeAndDecompressBody(ByteBuffer buffer, int code, int packetLength) {
        byte compressionType = (byte)((code & 0xFF000000) >> 24);
        boolean isCompressed = compressionType != 0;
        this.codeDecodedHook(code & 0xFFFFFF);
        if (isCompressed) {
            byte[] compressedData;
            int uncompressedSize = buffer.getInt();
            int compressedSize = packetLength - 4;
            int offset = 0;
            if (buffer.hasArray()) {
                compressedData = buffer.array();
                offset = buffer.arrayOffset() + buffer.position();
                buffer.position(buffer.position() + compressedSize);
            } else {
                compressedData = new byte[compressedSize];
                buffer.get(compressedData);
            }
            byte[] body = this.compressor.decompress(CompressionType.valueOf((byte)compressionType), compressedData, offset, uncompressedSize, Optional.of(compressedSize));
            ByteBuffer bodyBuffer = ByteBuffer.wrap(body);
            this.length += uncompressedSize - (compressedSize + 4);
            this.decodeBody(bodyBuffer);
        } else {
            this.decodeBody(buffer);
        }
    }

    public void decodeBody(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Decoding of " + this + " is not implemented");
    }

    protected void codeDecodedHook(int code) {
        if (code != this.getCode()) {
            throw new RuntimeException("Can not decode " + code + " into " + this);
        }
    }

    public BasicPacket encode(ByteBuffer buffer) throws BufferTooSmallException {
        int oldLimit = buffer.limit();
        int startPosition = buffer.position();
        buffer.limit(buffer.capacity());
        try {
            buffer.putInt(4);
            buffer.putInt(this.getCode());
            this.encodeAndCompressBody(buffer, startPosition);
        }
        catch (BufferOverflowException e) {
            buffer.position(startPosition);
            buffer.limit(oldLimit);
            throw new BufferTooSmallException("Destination buffer too small while encoding packet");
        }
        return this;
    }

    protected void encodeAndCompressBody(ByteBuffer buffer, int startPosition) {
        int startOfBody = buffer.position();
        this.encodeBody(buffer);
        this.setEncodedBody(buffer, startOfBody, buffer.position() - startOfBody);
        this.length = buffer.position() - startPosition;
        if (this.compressionLimit != 0 && this.length - 4 > this.compressionLimit) {
            this.compressionType = CompressionType.LZ4;
            LZ4Factory factory = LZ4Factory.fastestInstance();
            LZ4Compressor compressor = factory.fastCompressor();
            byte[] compressedBody = compressor.compress(this.encodedBody);
            log.log((Level)LogLevel.DEBUG, "Uncompressed size: " + this.encodedBody.length + ", Compressed size: " + compressedBody.length);
            if (compressedBody.length + 4 < this.encodedBody.length) {
                buffer.position(startPosition);
                buffer.putInt(compressedBody.length + startOfBody - startPosition + 4 - 4);
                buffer.putInt(this.getCompressedCode(this.compressionType));
                buffer.position(startOfBody);
                buffer.putInt(this.encodedBody.length);
                buffer.put(compressedBody);
                buffer.limit(buffer.position());
                return;
            }
        }
        buffer.putInt(startPosition, this.length - 4);
        buffer.limit(buffer.position());
    }

    private int getCompressedCode(CompressionType compression) {
        byte code = compression.getCode();
        return this.getCode() | code << 24;
    }

    protected void encodeBody(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Encoding of " + this + " is not implemented");
    }

    protected void setEncodedBody(ByteBuffer b, int start, int length) {
        this.encodedBody = new byte[length];
        b.position(start);
        b.get(this.encodedBody);
    }

    public boolean isEncoded() {
        return this.encodedBody != null;
    }

    public Packet encode(ByteBuffer buffer, int channel) throws BufferTooSmallException {
        throw new UnsupportedOperationException("This class does not support a channel ID");
    }

    public final void allocateAndEncode(int channelId) {
        this.allocateAndEncode(channelId, DEFAULT_WRITE_BUFFER_SIZE);
    }

    private final void allocateAndEncode(int channelId, int initialSize) {
        if (this.encodingBuffer != null) {
            this.patchChannelId(this.encodingBuffer, channelId);
            return;
        }
        int size = initialSize;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        while (true) {
            try {
                if (this.hasChannelId()) {
                    this.encode(buffer, channelId);
                } else {
                    this.encode(buffer);
                }
                buffer.flip();
                this.encodingBuffer = buffer;
            }
            catch (BufferTooSmallException e) {
                buffer = ByteBuffer.allocate(size *= 2);
                continue;
            }
            break;
        }
    }

    protected void patchChannelId(ByteBuffer buf, int channelId) {
    }

    public final ByteBuffer grantEncodingBuffer(int channelId) {
        if (this.encodingBuffer == null) {
            this.allocateAndEncode(channelId);
        } else {
            this.patchChannelId(this.encodingBuffer, channelId);
        }
        ByteBuffer b = this.encodingBuffer;
        this.encodingBuffer = null;
        return b;
    }

    public final ByteBuffer grantEncodingBuffer(int channelId, int initialSize) {
        if (this.encodingBuffer == null) {
            this.allocateAndEncode(channelId, initialSize);
        } else {
            this.patchChannelId(this.encodingBuffer, channelId);
        }
        ByteBuffer b = this.encodingBuffer;
        this.encodingBuffer = null;
        return b;
    }

    public abstract int getCode();

    public int getLength() {
        return this.length;
    }

    public void setTimestamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimestamp() {
        return this.timeStamp;
    }

    public String toString() {
        return "packet with code " + this.getCode();
    }

    public boolean hasChannelId() {
        return false;
    }
}

