/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.observability;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.Vtag;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.Container;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.handler.observability.ApplicationUserdataConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.filter.RequestFilterBase;
import com.yahoo.jdisc.http.filter.ResponseFilterBase;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingHandler;
import com.yahoo.search.handler.SearchHandler;
import com.yahoo.search.searchchain.SearchChainRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApplicationStatusHandler
extends AbstractRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private final JsonNode applicationJson;
    private final JsonNode clientsJson;
    private final JsonNode serversJson;
    private final JsonNode requestFiltersJson;
    private final JsonNode responseFiltersJson;
    private final JdiscBindingsConfig bindingsConfig;

    @Inject
    public ApplicationStatusHandler(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig, JdiscBindingsConfig bindingsConfig, ComponentRegistry<ClientProvider> clientProviderRegistry, ComponentRegistry<ServerProvider> serverProviderRegistry, ComponentRegistry<RequestFilterBase> requestFilterRegistry, ComponentRegistry<ResponseFilterBase> responseFilterRegistry) {
        this.applicationJson = ApplicationStatusHandler.renderApplicationConfigs(metaConfig, userConfig);
        this.clientsJson = ApplicationStatusHandler.renderRequestHandlers(bindingsConfig, clientProviderRegistry.allComponentsById());
        this.serversJson = ApplicationStatusHandler.renderObjectComponents(serverProviderRegistry.allComponentsById());
        this.requestFiltersJson = ApplicationStatusHandler.renderObjectComponents(requestFilterRegistry.allComponentsById());
        this.responseFiltersJson = ApplicationStatusHandler.renderObjectComponents(responseFilterRegistry.allComponentsById());
        this.bindingsConfig = bindingsConfig;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        JsonNode json = new StatusResponse(this.applicationJson, this.clientsJson, this.serversJson, this.requestFiltersJson, this.responseFiltersJson, this.bindingsConfig).render();
        FastContentWriter writer = new FastContentWriter(new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", List.of("application/json"));
                return response;
            }
        }.connect(handler));
        try {
            writer.write(jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)json));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Invalid JSON: " + e.getMessage(), e);
        }
        writer.close();
        return new IgnoredContent();
    }

    static JsonNode renderApplicationConfigs(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig) {
        ObjectNode vespa = jsonMapper.createObjectNode();
        vespa.put("version", Vtag.currentVersion.toString());
        ObjectNode meta = jsonMapper.createObjectNode();
        meta.put("name", metaConfig.name());
        meta.put("user", metaConfig.user());
        meta.put("path", metaConfig.path());
        meta.put("generation", metaConfig.generation());
        meta.put("timestamp", metaConfig.timestamp());
        meta.put("date", new Date(metaConfig.timestamp()).toString());
        meta.put("checksum", metaConfig.checksum());
        ObjectNode user = jsonMapper.createObjectNode();
        user.put("version", userConfig.version());
        ObjectNode application = jsonMapper.createObjectNode();
        application.set("vespa", (JsonNode)vespa);
        application.set("meta", (JsonNode)meta);
        application.set("user", (JsonNode)user);
        return application;
    }

    static JsonNode renderObjectComponents(Map<ComponentId, ?> componentsById) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Map.Entry<ComponentId, ?> componentEntry : componentsById.entrySet()) {
            ObjectNode jc = ApplicationStatusHandler.renderComponent(componentEntry.getValue(), componentEntry.getKey());
            ret.add((JsonNode)jc);
        }
        return ret;
    }

    static JsonNode renderRequestHandlers(JdiscBindingsConfig bindingsConfig, Map<ComponentId, ? extends RequestHandler> handlersById) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Map.Entry<ComponentId, ? extends RequestHandler> handlerEntry : handlersById.entrySet()) {
            String id = handlerEntry.getKey().stringValue();
            RequestHandler handler = handlerEntry.getValue();
            ObjectNode handlerJson = ApplicationStatusHandler.renderComponent(handler, handlerEntry.getKey());
            ApplicationStatusHandler.addBindings(bindingsConfig, id, handlerJson);
            ret.add((JsonNode)handlerJson);
        }
        return ret;
    }

    private static void addBindings(JdiscBindingsConfig bindingsConfig, String id, ObjectNode handlerJson) {
        ArrayList<String> serverBindings = new ArrayList();
        ArrayList<String> clientBindings = new ArrayList();
        JdiscBindingsConfig.Handlers handlerConfig = bindingsConfig.handlers(id);
        if (handlerConfig != null) {
            serverBindings = handlerConfig.serverBindings();
            clientBindings = handlerConfig.clientBindings();
        }
        handlerJson.set("serverBindings", ApplicationStatusHandler.renderBindings(serverBindings));
        handlerJson.set("clientBindings", ApplicationStatusHandler.renderBindings(clientBindings));
    }

    private static JsonNode renderBindings(List<String> bindings) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (String binding : bindings) {
            ret.add(binding);
        }
        return ret;
    }

    private static JsonNode renderAbstractComponents(List<? extends AbstractComponent> components) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (AbstractComponent abstractComponent : components) {
            ObjectNode jc = ApplicationStatusHandler.renderComponent(abstractComponent, abstractComponent.getId());
            ret.add((JsonNode)jc);
        }
        return ret;
    }

    private static ObjectNode renderComponent(Object component, ComponentId id) {
        ObjectNode jc = jsonMapper.createObjectNode();
        jc.put("id", id.stringValue());
        ApplicationStatusHandler.addBundleInfo(jc, component);
        return jc;
    }

    private static void addBundleInfo(ObjectNode jsonObject, Object component) {
        BundleInfo bundleInfo = ApplicationStatusHandler.bundleInfo(component);
        jsonObject.put("class", bundleInfo.className);
        jsonObject.put("bundle", bundleInfo.bundleName);
    }

    private static BundleInfo bundleInfo(Object component) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(component.getClass());
            String bundleName = bundle != null ? bundle.getSymbolicName() + ":" + bundle.getVersion() : "From classpath";
            return new BundleInfo(component.getClass().getName(), bundleName);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new BundleInfo("Unavailable, reconfiguration in progress.", "");
        }
    }

    private class IgnoredContent
    implements ContentChannel {
        private IgnoredContent() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    }

    static final class StatusResponse {
        private final JsonNode applicationJson;
        private final JsonNode clientsJson;
        private final JsonNode serversJson;
        private final JsonNode requestFiltersJson;
        private final JsonNode responseFiltersJson;
        private final JdiscBindingsConfig bindingsConfig;

        StatusResponse(JsonNode applicationJson, JsonNode clientsJson, JsonNode serversJson, JsonNode requestFiltersJson, JsonNode responseFiltersJson, JdiscBindingsConfig bindingsConfig) {
            this.applicationJson = applicationJson;
            this.clientsJson = clientsJson;
            this.serversJson = serversJson;
            this.requestFiltersJson = requestFiltersJson;
            this.responseFiltersJson = responseFiltersJson;
            this.bindingsConfig = bindingsConfig;
        }

        public JsonNode render() {
            ObjectNode root = jsonMapper.createObjectNode();
            root.set("application", this.applicationJson);
            root.set("abstractComponents", ApplicationStatusHandler.renderAbstractComponents(Container.get().getComponentRegistry().allComponents()));
            root.set("handlers", ApplicationStatusHandler.renderRequestHandlers(this.bindingsConfig, Container.get().getRequestHandlerRegistry().allComponentsById()));
            root.set("clients", this.clientsJson);
            root.set("servers", this.serversJson);
            root.set("httpRequestFilters", this.requestFiltersJson);
            root.set("httpResponseFilters", this.responseFiltersJson);
            root.set("searchChains", StatusResponse.renderSearchChains(Container.get()));
            root.set("docprocChains", StatusResponse.renderDocprocChains(Container.get()));
            root.set("processingChains", StatusResponse.renderProcessingChains(Container.get()));
            return root;
        }

        private static JsonNode renderSearchChains(Container container) {
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof SearchHandler)) continue;
                SearchChainRegistry scReg = ((SearchHandler)h).getSearchChainRegistry();
                return StatusResponse.renderChains(scReg);
            }
            return jsonMapper.createObjectNode();
        }

        private static JsonNode renderDocprocChains(Container container) {
            ObjectNode ret = jsonMapper.createObjectNode();
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof DocumentProcessingHandler)) continue;
                ComponentRegistry registry = ((DocumentProcessingHandler)h).getDocprocServiceRegistry();
                for (DocprocService service : registry.allComponents()) {
                    ret.set(service.getId().stringValue(), StatusResponse.renderCalls(service.getCallStack().iterator()));
                }
            }
            return ret;
        }

        private static JsonNode renderProcessingChains(Container container) {
            ObjectNode ret = jsonMapper.createObjectNode();
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof ProcessingHandler)) continue;
                ChainRegistry registry = ((ProcessingHandler)h).getChainRegistry();
                return StatusResponse.renderChains(registry);
            }
            return ret;
        }

        static JsonNode renderChains(ComponentRegistry<? extends Chain<?>> chains) {
            ObjectNode ret = jsonMapper.createObjectNode();
            for (Chain chain : chains.allComponents()) {
                ret.set(chain.getId().stringValue(), ApplicationStatusHandler.renderAbstractComponents(chain.components()));
            }
            return ret;
        }

        private static JsonNode renderCalls(Iterator<Call> components) {
            ArrayNode ret = jsonMapper.createArrayNode();
            while (components.hasNext()) {
                Call c = components.next();
                ObjectNode jc = ApplicationStatusHandler.renderComponent(c.getDocumentProcessor(), c.getDocumentProcessor().getId());
                ret.add((JsonNode)jc);
            }
            return ret;
        }
    }

    static final class BundleInfo {
        public final String className;
        public final String bundleName;

        BundleInfo(String className, String bundleName) {
            this.className = className;
            this.bundleName = bundleName;
        }
    }
}

